"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeOptionsListSelections = initializeOptionsListSelections;
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function initializeOptionsListSelections(initialState, onSelectionChange) {
  var _initialState$selecte, _initialState$selecte2;
  const selectedOptions$ = new _rxjs.BehaviorSubject((_initialState$selecte = initialState.selectedOptions) !== null && _initialState$selecte !== void 0 ? _initialState$selecte : []);
  const selectedOptionsComparatorFunction = (a, b) => (0, _reactFastCompare.default)(a !== null && a !== void 0 ? a : [], b !== null && b !== void 0 ? b : []);
  function setSelectedOptions(next) {
    if (!selectedOptionsComparatorFunction(selectedOptions$.value, next)) {
      selectedOptions$.next(next);
      onSelectionChange();
    }
  }
  const existsSelected$ = new _rxjs.BehaviorSubject(initialState.existsSelected);
  function setExistsSelected(next) {
    if (existsSelected$.value !== next) {
      existsSelected$.next(next);
      onSelectionChange();
    }
  }
  const exclude$ = new _rxjs.BehaviorSubject(initialState.exclude);
  function setExclude(next) {
    if (exclude$.value !== next) {
      exclude$.next(next);
      onSelectionChange();
    }
  }
  return {
    comparators: {
      exclude: [exclude$, setExclude],
      existsSelected: [existsSelected$, setExistsSelected],
      selectedOptions: [selectedOptions$, setSelectedOptions, selectedOptionsComparatorFunction]
    },
    hasInitialSelections: ((_initialState$selecte2 = initialState.selectedOptions) === null || _initialState$selecte2 === void 0 ? void 0 : _initialState$selecte2.length) || initialState.existsSelected,
    selectedOptions$: selectedOptions$,
    setSelectedOptions,
    existsSelected$: existsSelected$,
    setExistsSelected,
    exclude$: exclude$,
    setExclude
  };
}