"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataControlEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
var _std = require("@kbn/std");
var _common = require("../../../common");
var _kibana_services = require("../../services/kibana_services");
var _control_factory_registry = require("../../control_factory_registry");
var _data_control_constants = require("./data_control_constants");
var _data_control_editor_utils = require("./data_control_editor_utils");
var _editor_constants = require("./editor_constants");
var _types = require("./types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const FieldPicker = (0, _public.withSuspense)(_public.LazyFieldPicker, null);
const DataViewPicker = (0, _public.withSuspense)(_public.LazyDataViewPicker, null);
const CompatibleControlTypesComponent = ({
  fieldRegistry,
  selectedFieldName,
  selectedControlType,
  setSelectedControlType
}) => {
  const [dataControlFactories, setDataControlFactories] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    let cancelled = false;
    (0, _std.asyncMap)((0, _control_factory_registry.getAllControlTypes)(), async controlType => (0, _control_factory_registry.getControlFactory)(controlType)).then(controlFactories => {
      if (!cancelled) {
        setDataControlFactories(controlFactories.filter(factory => (0, _types.isDataControlFactory)(factory)).sort(({
          order: orderA = 0,
          getDisplayName: getDisplayNameA
        }, {
          order: orderB = 0,
          getDisplayName: getDisplayNameB
        }) => {
          const orderComparison = orderB - orderA; // sort descending by order
          return orderComparison === 0 ? getDisplayNameA().localeCompare(getDisplayNameB()) // if equal order, compare display names
          : orderComparison;
        }));
      }
    }).catch(() => {
      if (!cancelled) setDataControlFactories([]);
    });
    return () => {
      cancelled = true;
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    isLoading: dataControlFactories === undefined,
    width: "100px",
    height: "100px"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenu, {
    "data-test-subj": `controlTypeMenu`,
    "aria-label": 'type'
  }, (dataControlFactories !== null && dataControlFactories !== void 0 ? dataControlFactories : []).map(factory => {
    var _fieldRegistry$select;
    const disabled = fieldRegistry && selectedFieldName ? !((_fieldRegistry$select = fieldRegistry[selectedFieldName]) !== null && _fieldRegistry$select !== void 0 && _fieldRegistry$select.compatibleControlTypes.includes(factory.type)) : true;
    const keyPadMenuItem = /*#__PURE__*/_react.default.createElement(_eui.EuiKeyPadMenuItem, {
      key: factory.type,
      id: `create__${factory.type}`,
      "aria-label": factory.getDisplayName(),
      "data-test-subj": `create__${factory.type}`,
      isSelected: factory.type === selectedControlType,
      disabled: disabled,
      onClick: () => setSelectedControlType(factory.type),
      label: factory.getDisplayName()
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: factory.getIconType(),
      size: "l"
    }));
    return disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      key: `disabled__${factory.type}`,
      content: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getControlTypeErrorMessage({
        fieldSelected: Boolean(selectedFieldName),
        controlType: factory.getDisplayName()
      })
    }, keyPadMenuItem) : keyPadMenuItem;
  })));
};
const DataControlEditor = ({
  initialState,
  controlId,
  controlType,
  initialDefaultPanelTitle,
  onSave,
  onCancel,
  controlGroupApi
}) => {
  var _ref, _initialState$title, _selectedDataView$get, _editorState$width, _editorState$grow, _editorState$title, _editorState$title2, _editorState$title3;
  const [editorState, setEditorState] = (0, _react.useState)(initialState);
  const [defaultPanelTitle, setDefaultPanelTitle] = (0, _react.useState)((_ref = initialDefaultPanelTitle !== null && initialDefaultPanelTitle !== void 0 ? initialDefaultPanelTitle : initialState.fieldName) !== null && _ref !== void 0 ? _ref : '');
  const [panelTitle, setPanelTitle] = (0, _react.useState)((_initialState$title = initialState.title) !== null && _initialState$title !== void 0 ? _initialState$title : defaultPanelTitle);
  const [selectedControlType, setSelectedControlType] = (0, _react.useState)(controlType);
  const [controlOptionsValid, setControlOptionsValid] = (0, _react.useState)(true);
  const editorConfig = (0, _react.useMemo)(() => controlGroupApi.getEditorConfig(), [controlGroupApi]);
  const {
    loading: dataViewListLoading,
    value: dataViewListItems = [],
    error: dataViewListError
  } = (0, _useAsync.default)(async () => {
    return _kibana_services.dataViewsService.getIdsWithTitle();
  });
  const {
    loading: dataViewLoading,
    value: {
      selectedDataView,
      fieldRegistry
    } = {
      selectedDataView: undefined,
      fieldRegistry: undefined
    },
    error: fieldListError
  } = (0, _useAsync.default)(async () => {
    if (!editorState.dataViewId) {
      return;
    }
    const dataView = await _kibana_services.dataViewsService.get(editorState.dataViewId);
    const registry = await (0, _data_control_editor_utils.getDataControlFieldRegistry)(dataView);
    return {
      selectedDataView: dataView,
      fieldRegistry: registry
    };
  }, [editorState.dataViewId]);
  const [controlFactory, setControlFactory] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    if (!selectedControlType) {
      setControlFactory(undefined);
      return;
    }
    let cancelled = false;
    (0, _control_factory_registry.getControlFactory)(selectedControlType).then(nextControlFactory => {
      if (!cancelled) {
        setControlFactory(nextControlFactory);
      }
    }).catch(() => {
      if (!cancelled) {
        setControlFactory(undefined);
      }
    });
    return () => {
      cancelled = true;
    };
  }, [selectedControlType]);
  const CustomSettingsComponent = (0, _react.useMemo)(() => {
    if (!controlFactory || !editorState.fieldName || !fieldRegistry) return;
    const CustomSettings = controlFactory.CustomOptionsComponent;
    if (!CustomSettings) return;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "control-editor-custom-settings"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(CustomSettings, {
      initialState: initialState,
      field: fieldRegistry[editorState.fieldName].field,
      updateState: newState => setEditorState({
        ...editorState,
        ...newState
      }),
      setControlEditorValid: setControlOptionsValid,
      controlGroupApi: controlGroupApi
    }));
  }, [fieldRegistry, controlFactory, initialState, editorState, controlGroupApi]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, !controlId // if no ID, then we are creating a new control
  ? _data_control_constants.DataControlEditorStrings.manageControl.getFlyoutCreateTitle() : _data_control_constants.DataControlEditorStrings.manageControl.getFlyoutEditTitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "control-editor-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true
  }, !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideDataViewSelector) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "control-editor-data-view-picker",
    label: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getDataViewTitle()
  }, dataViewListError ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "error",
    title: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getDataViewListErrorTitle()
  }, /*#__PURE__*/_react.default.createElement("p", null, dataViewListError.message)) : /*#__PURE__*/_react.default.createElement(DataViewPicker, {
    dataViews: dataViewListItems,
    selectedDataViewId: editorState.dataViewId,
    onChangeDataViewId: newDataViewId => {
      setEditorState({
        ...editorState,
        dataViewId: newDataViewId
      });
      setSelectedControlType(undefined);
    },
    trigger: {
      label: (_selectedDataView$get = selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.getName()) !== null && _selectedDataView$get !== void 0 ? _selectedDataView$get : _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getSelectDataViewMessage()
    },
    selectableProps: {
      isLoading: dataViewListLoading
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getFieldTitle()
  }, fieldListError ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "error",
    title: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getFieldListErrorTitle()
  }, /*#__PURE__*/_react.default.createElement("p", null, fieldListError.message)) : /*#__PURE__*/_react.default.createElement(FieldPicker, {
    filterPredicate: field => {
      var _editorConfig$fieldFi, _editorConfig$fieldFi2;
      const customPredicate = (_editorConfig$fieldFi = editorConfig === null || editorConfig === void 0 ? void 0 : (_editorConfig$fieldFi2 = editorConfig.fieldFilterPredicate) === null || _editorConfig$fieldFi2 === void 0 ? void 0 : _editorConfig$fieldFi2.call(editorConfig, field)) !== null && _editorConfig$fieldFi !== void 0 ? _editorConfig$fieldFi : true;
      return Boolean(fieldRegistry === null || fieldRegistry === void 0 ? void 0 : fieldRegistry[field.name]) && customPredicate;
    },
    selectedFieldName: editorState.fieldName,
    dataView: selectedDataView,
    onSelectField: field => {
      var _fieldRegistry$field$, _fieldRegistry$field$2, _field$displayName;
      setEditorState({
        ...editorState,
        fieldName: field.name
      });

      /**
       * make sure that the new field is compatible with the selected control type and, if it's not,
       * reset the selected control type to the **first** compatible control type
       */
      const newCompatibleControlTypes = (_fieldRegistry$field$ = fieldRegistry === null || fieldRegistry === void 0 ? void 0 : (_fieldRegistry$field$2 = fieldRegistry[field.name]) === null || _fieldRegistry$field$2 === void 0 ? void 0 : _fieldRegistry$field$2.compatibleControlTypes) !== null && _fieldRegistry$field$ !== void 0 ? _fieldRegistry$field$ : [];
      if (!selectedControlType || !newCompatibleControlTypes.includes(selectedControlType)) {
        setSelectedControlType(newCompatibleControlTypes[0]);
      }

      /**
       * set the control title (i.e. the one set by the user) + default title (i.e. the field display name)
       */
      const newDefaultTitle = (_field$displayName = field.displayName) !== null && _field$displayName !== void 0 ? _field$displayName : field.name;
      setDefaultPanelTitle(newDefaultTitle);
      const currentTitle = editorState.title;
      if (!currentTitle || currentTitle === newDefaultTitle) {
        setPanelTitle(newDefaultTitle);
      }
      setControlOptionsValid(true); // reset options state
    },
    selectableProps: {
      isLoading: dataViewListLoading || dataViewLoading
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _data_control_constants.DataControlEditorStrings.manageControl.dataSource.getControlTypeTitle()
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(CompatibleControlTypesComponent, {
    fieldRegistry: fieldRegistry,
    selectedFieldName: editorState.fieldName,
    selectedControlType: selectedControlType,
    setSelectedControlType: setSelectedControlType
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _data_control_constants.DataControlEditorStrings.manageControl.displaySettings.getTitleInputTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "control-editor-title-input",
    placeholder: defaultPanelTitle,
    value: panelTitle,
    compressed: true,
    onChange: e => {
      var _e$target$value;
      setPanelTitle((_e$target$value = e.target.value) !== null && _e$target$value !== void 0 ? _e$target$value : '');
      setEditorState({
        ...editorState,
        title: e.target.value === '' ? undefined : e.target.value
      });
    }
  })), !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideWidthSettings) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "control-editor-width-settings",
    label: _data_control_constants.DataControlEditorStrings.manageControl.displaySettings.getWidthInputTitle()
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    buttonSize: "compressed",
    legend: _data_control_constants.DataControlEditorStrings.management.controlWidth.getWidthSwitchLegend(),
    options: _editor_constants.CONTROL_WIDTH_OPTIONS,
    idSelected: (_editorState$width = editorState.width) !== null && _editorState$width !== void 0 ? _editorState$width : _common.DEFAULT_CONTROL_WIDTH,
    onChange: newWidth => setEditorState({
      ...editorState,
      width: newWidth
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _data_control_constants.DataControlEditorStrings.manageControl.displaySettings.getGrowSwitchTitle(),
    color: "primary",
    checked: (_editorState$grow = editorState.grow) !== null && _editorState$grow !== void 0 ? _editorState$grow : _common.DEFAULT_CONTROL_GROW,
    onChange: () => setEditorState({
      ...editorState,
      grow: !editorState.grow
    }),
    "data-test-subj": "control-editor-grow-switch"
  }))), !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideAdditionalSettings) && CustomSettingsComponent, controlId && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": `delete-${(_editorState$title = editorState.title) !== null && _editorState$title !== void 0 ? _editorState$title : editorState.fieldName}`,
    iconType: "trash",
    flush: "left",
    color: "danger",
    onClick: () => {
      onCancel(initialState); // don't want to show "lost changes" warning
      controlGroupApi.removePanel(controlId);
    }
  }, _data_control_constants.DataControlEditorStrings.manageControl.getDeleteButtonTitle())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": `cancel-${(_editorState$title2 = editorState.title) !== null && _editorState$title2 !== void 0 ? _editorState$title2 : editorState.fieldName}`,
    "data-test-subj": "control-editor-cancel",
    onClick: () => {
      onCancel(editorState);
    }
  }, _data_control_constants.DataControlEditorStrings.manageControl.getCancelTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": `save-${(_editorState$title3 = editorState.title) !== null && _editorState$title3 !== void 0 ? _editorState$title3 : editorState.fieldName}`,
    "data-test-subj": "control-editor-save",
    fill: true,
    color: "primary",
    disabled: !(controlOptionsValid && Boolean(editorState.fieldName) && Boolean(selectedDataView) && Boolean(selectedControlType)),
    onClick: () => {
      onSave(editorState, selectedControlType);
    }
  }, _data_control_constants.DataControlEditorStrings.manageControl.getSaveChangesTitle())))));
};
exports.DataControlEditor = DataControlEditor;