"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroupRenderer = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _uuid = require("uuid");
var _public = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _common = require("../../../common");
var _control_group_state_builder = require("../utils/control_group_state_builder");
var _initialization_utils = require("../utils/initialization_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ControlGroupRenderer = ({
  onApiAvailable,
  getCreationOptions,
  filters,
  timeRange,
  query,
  viewMode,
  dataLoading,
  compressed
}) => {
  const id = (0, _react.useMemo)(() => (0, _uuid.v4)(), []);
  const [regenerateId, setRegenerateId] = (0, _react.useState)((0, _uuid.v4)());
  const [controlGroup, setControlGroup] = (0, _react.useState)();

  /**
   * Parent API set up
   */
  const searchApi = (0, _presentationPublishing.useSearchApi)({
    filters,
    query,
    timeRange
  });
  const viewMode$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(viewMode !== null && viewMode !== void 0 ? viewMode : _public.ViewMode.VIEW),
  // viewMode only used as initial value - changes do not effect memoized value.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  (0, _react.useEffect)(() => {
    if (viewMode) viewMode$.next(viewMode);
  }, [viewMode, viewMode$]);
  const dataLoading$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject(Boolean(dataLoading)),
  // dataLoading only used as initial value - changes do not effect memoized value.
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  (0, _react.useEffect)(() => {
    if (dataLoading !== dataLoading$.getValue()) dataLoading$.next(Boolean(dataLoading));
  }, [dataLoading, dataLoading$]);
  const reload$ = (0, _react.useMemo)(() => new _rxjs.Subject(), []);

  /**
   * Control group API set up
   */
  const runtimeState$ = (0, _react.useMemo)(() => new _rxjs.BehaviorSubject((0, _initialization_utils.getDefaultControlGroupRuntimeState)()), []);
  const [serializedState, setSerializedState] = (0, _react.useState)();
  const updateInput = (0, _react.useCallback)(newState => {
    runtimeState$.next({
      ...runtimeState$.getValue(),
      ...newState
    });
  }, [runtimeState$]);

  /**
   * To mimic `input$`, subscribe to unsaved changes and snapshot the runtime state whenever
   * something change
   */
  (0, _react.useEffect)(() => {
    if (!controlGroup) return;
    const stateChangeSubscription = controlGroup.unsavedChanges$.subscribe(changes => {
      runtimeState$.next({
        ...runtimeState$.getValue(),
        ...changes
      });
    });
    return () => {
      stateChangeSubscription.unsubscribe();
    };
  }, [controlGroup, runtimeState$]);

  /**
   * On mount
   */
  (0, _react.useEffect)(() => {
    let cancelled = false;
    (async (_await$getCreationOpt, _initialState$autoApp, _initialState$labelPo, _initialState$chainin, _initialState$initial) => {
      const {
        initialState,
        editorConfig
      } = (_await$getCreationOpt = await (getCreationOptions === null || getCreationOptions === void 0 ? void 0 : getCreationOptions((0, _initialization_utils.getDefaultControlGroupRuntimeState)(), _control_group_state_builder.controlGroupStateBuilder))) !== null && _await$getCreationOpt !== void 0 ? _await$getCreationOpt : {};
      updateInput({
        ...initialState,
        editorConfig
      });
      const state = {
        ...(0, _lodash.omit)(initialState, ['initialChildControlState']),
        editorConfig,
        autoApplySelections: (_initialState$autoApp = initialState === null || initialState === void 0 ? void 0 : initialState.autoApplySelections) !== null && _initialState$autoApp !== void 0 ? _initialState$autoApp : _common.DEFAULT_AUTO_APPLY_SELECTIONS,
        labelPosition: (_initialState$labelPo = initialState === null || initialState === void 0 ? void 0 : initialState.labelPosition) !== null && _initialState$labelPo !== void 0 ? _initialState$labelPo : _common.DEFAULT_CONTROL_LABEL_POSITION,
        chainingSystem: (_initialState$chainin = initialState === null || initialState === void 0 ? void 0 : initialState.chainingSystem) !== null && _initialState$chainin !== void 0 ? _initialState$chainin : _common.DEFAULT_CONTROL_CHAINING,
        controls: Object.entries((_initialState$initial = initialState === null || initialState === void 0 ? void 0 : initialState.initialChildControlState) !== null && _initialState$initial !== void 0 ? _initialState$initial : {}).map(([controlId, value]) => ({
          ...value,
          id: controlId
        }))
      };
      if (!cancelled) {
        setSerializedState(state);
      }
    })();
    return () => {
      cancelled = true;
    };
    // exhaustive deps disabled because we want the control group to be created only on first render.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return !serializedState ? null : /*#__PURE__*/_react.default.createElement(_public.ReactEmbeddableRenderer, {
    key: regenerateId // this key forces a re-mount when `updateInput` is called
    ,
    maybeId: id,
    type: _common.CONTROL_GROUP_TYPE,
    getParentApi: () => ({
      reload$,
      dataLoading$,
      viewMode$,
      query$: searchApi.query$,
      timeRange$: searchApi.timeRange$,
      unifiedSearchFilters$: searchApi.filters$,
      getSerializedStateForChild: () => ({
        rawState: serializedState
      }),
      getRuntimeStateForChild: () => {
        return runtimeState$.getValue();
      },
      compressed: compressed !== null && compressed !== void 0 ? compressed : true
    }),
    onApiAvailable: controlGroupApi => {
      const controlGroupRendererApi = {
        ...controlGroupApi,
        reload: () => reload$.next(),
        updateInput: newInput => {
          updateInput(newInput);
          setRegenerateId((0, _uuid.v4)()); // force remount
        },
        getInput$: () => runtimeState$
      };
      setControlGroup(controlGroupRendererApi);
      onApiAvailable(controlGroupRendererApi);
    },
    hidePanelChrome: true,
    panelProps: {
      hideLoader: true
    }
  });
};
exports.ControlGroupRenderer = ControlGroupRenderer;