"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOUR_STORAGE_KEY = exports.SHELL_TOUR_STEP = exports.SHELL_TAB_ID = exports.INITIAL_TOUR_CONFIG = exports.HISTORY_TOUR_STEP = exports.HISTORY_TAB_ID = exports.FILES_TOUR_STEP = exports.EXPORT_FILE_NAME = exports.EDITOR_TOUR_STEP = exports.CONFIG_TOUR_STEP = exports.CONFIG_TAB_ID = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const SHELL_TAB_ID = exports.SHELL_TAB_ID = 'shell';
const HISTORY_TAB_ID = exports.HISTORY_TAB_ID = 'history';
const CONFIG_TAB_ID = exports.CONFIG_TAB_ID = 'config';
const SHELL_TOUR_STEP = exports.SHELL_TOUR_STEP = 1;
const EDITOR_TOUR_STEP = exports.EDITOR_TOUR_STEP = 2;
const HISTORY_TOUR_STEP = exports.HISTORY_TOUR_STEP = 3;
const CONFIG_TOUR_STEP = exports.CONFIG_TOUR_STEP = 4;
const FILES_TOUR_STEP = exports.FILES_TOUR_STEP = 5;

// Key used for storing tour state in local storage
const TOUR_STORAGE_KEY = exports.TOUR_STORAGE_KEY = 'consoleTour';
const INITIAL_TOUR_CONFIG = exports.INITIAL_TOUR_CONFIG = {
  currentTourStep: 1,
  isTourActive: true,
  tourPopoverWidth: 360,
  tourSubtitle: 'Console onboarding' // Used for state in local storage
};
const EXPORT_FILE_NAME = exports.EXPORT_FILE_NAME = 'console_export';