"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomizablePalette = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _palette_picker = require("./palette_picker");
var _palettes = require("../../palettes");
var _utils = require("./utils");
var _color_ranges = require("./color_ranges");
var _color_ranges_validation = require("./color_ranges/color_ranges_validation");
var _palette_configuration_reducer = require("./palette_configuration_reducer");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CustomizablePalette = ({
  palettes,
  activePalette,
  setPalette,
  dataBounds = (0, _palettes.getFallbackDataBounds)((_activePalette$params => (_activePalette$params = activePalette.params) === null || _activePalette$params === void 0 ? void 0 : _activePalette$params.rangeType)()),
  showExtraActions = true,
  showRangeTypeSelector = true,
  disableSwitchingContinuity = false
}) => {
  var _activePalette$params2, _localState$activePal2, _localState$activePal3, _localState$activePal4;
  const idPrefix = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const colorRangesToShow = (0, _utils.toColorRanges)(palettes, ((_activePalette$params2 = activePalette.params) === null || _activePalette$params2 === void 0 ? void 0 : _activePalette$params2.colorStops) || [], activePalette, dataBounds);
  const [localState, dispatch] = (0, _react.useReducer)(_palette_configuration_reducer.paletteConfigurationReducer, {
    activePalette,
    colorRanges: colorRangesToShow
  });
  (0, _useDebounce.default)(() => {
    var _localState$activePal;
    if ((localState.activePalette !== activePalette || colorRangesToShow !== localState.colorRanges) && (0, _color_ranges_validation.allRangesValid)(localState.colorRanges, ((_localState$activePal = localState.activePalette.params) === null || _localState$activePal === void 0 ? void 0 : _localState$activePal.rangeType) === 'percent')) {
      setPalette(localState.activePalette);
    }
  }, 250, [localState]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = (0, _react.useMemo)(() => (0, _react2.css)`
      padding: ${euiTheme.size.base};
    `, [euiTheme.size.base]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles,
    className: "lnsPalettePanel__section"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: _i18n.i18n.translate('coloring.dynamicColoring.palettePicker.label', {
      defaultMessage: 'Color palette'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_palette_picker.PalettePicker, {
    "data-test-subj": "lnsPalettePanel_dynamicColoring_palette_picker",
    palettes: palettes,
    activePalette: localState.activePalette,
    setPalette: newPalette => {
      const isPaletteChanged = newPalette.name !== activePalette.name;
      if (isPaletteChanged) {
        dispatch({
          type: 'changeColorPalette',
          payload: {
            palette: newPalette,
            dataBounds,
            palettes,
            disableSwitchingContinuity
          }
        });
      }
    },
    showCustomPalette: true,
    showDynamicColorOnly: true
  })), showRangeTypeSelector && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('coloring.dynamicColoring.rangeType.label', {
      defaultMessage: 'Value type'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('coloring.dynamicColoring.customPalette.colorStopsHelpPercentage', {
        defaultMessage: 'Percent value types are relative to the full range of available data values.'
      }),
      position: "top",
      size: "s"
    })),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('coloring.dynamicColoring.rangeType.label', {
      defaultMessage: 'Value type'
    }),
    "data-test-subj": "lnsPalettePanel_dynamicColoring_custom_range_groups",
    name: "dynamicColoringRangeType",
    buttonSize: "compressed",
    options: [{
      id: `${idPrefix}percent`,
      label: _i18n.i18n.translate('coloring.dynamicColoring.rangeType.percent', {
        defaultMessage: 'Percent'
      }),
      'data-test-subj': 'lnsPalettePanel_dynamicColoring_rangeType_groups_percent'
    }, {
      id: `${idPrefix}number`,
      label: _i18n.i18n.translate('coloring.dynamicColoring.rangeType.number', {
        defaultMessage: 'Number'
      }),
      'data-test-subj': 'lnsPalettePanel_dynamicColoring_rangeType_groups_number'
    }],
    idSelected: (_localState$activePal2 = localState.activePalette.params) !== null && _localState$activePal2 !== void 0 && _localState$activePal2.rangeType ? `${idPrefix}${(_localState$activePal3 = localState.activePalette.params) === null || _localState$activePal3 === void 0 ? void 0 : _localState$activePal3.rangeType}` : `${idPrefix}percent`,
    onChange: id => {
      const newRangeType = id.replace(idPrefix, '');
      dispatch({
        type: 'updateRangeType',
        payload: {
          rangeType: newRangeType,
          dataBounds,
          palettes
        }
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('coloring.dynamicColoring.palettePicker.colorRangesLabel', {
      defaultMessage: 'Color Ranges'
    }),
    display: "rowCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_color_ranges.ColorRangesContext.Provider, {
    value: {
      dataBounds,
      palettes,
      disableSwitchingContinuity
    }
  }, /*#__PURE__*/_react.default.createElement(_color_ranges.ColorRanges, {
    showExtraActions: showExtraActions,
    paletteConfiguration: (_localState$activePal4 = localState.activePalette) === null || _localState$activePal4 === void 0 ? void 0 : _localState$activePal4.params,
    colorRanges: localState.colorRanges,
    dispatch: dispatch
  }))));
};
exports.CustomizablePalette = CustomizablePalette;