"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaletteSelector = PaletteSelector;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _color_mapping = require("../../state/color_mapping");
var _assignments = require("../../config/assignments");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function PaletteSelector({
  palettes,
  getPaletteFn,
  isDarkMode
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const model = (0, _reactRedux.useSelector)(state => state.colorMapping);
  const switchPaletteFn = (0, _react.useCallback)((selectedPaletteId, preserveColorChanges) => {
    dispatch((0, _color_mapping.updatePalette)({
      paletteId: selectedPaletteId,
      assignments: (0, _assignments.updateAssignmentsPalette)(model.assignments, model.colorMode, selectedPaletteId, getPaletteFn, preserveColorChanges),
      colorMode: (0, _assignments.updateColorModePalette)(model.colorMode, selectedPaletteId, preserveColorChanges)
    }));
  }, [getPaletteFn, model, dispatch]);
  const [preserveModalPaletteId, setPreserveModalPaletteId] = (0, _react.useState)(null);
  const preserveChangesModal = preserveModalPaletteId !== null ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.title', {
      defaultMessage: 'Color changes detected'
    }),
    onCancel: () => {
      if (preserveModalPaletteId) switchPaletteFn(preserveModalPaletteId, true);
      setPreserveModalPaletteId(null);
    },
    onConfirm: () => {
      if (preserveModalPaletteId) switchPaletteFn(preserveModalPaletteId, false);
      setPreserveModalPaletteId(null);
    },
    confirmButtonText: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.discardButton', {
      defaultMessage: 'Discard changes'
    }),
    cancelButtonText: _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.preserveButton', {
      defaultMessage: 'Preserve changes'
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('coloring.colorMapping.colorChangesModal.switchPaletteDescription', {
    defaultMessage: 'Switching palette will discard all your custom color changes'
  }))) : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, preserveChangesModal, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('coloring.colorMapping.paletteSelector.paletteLabel', {
      defaultMessage: `Color palette`
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, {
    "data-test-subj": "kbnColoring_ColorMapping_PalettePicker",
    fullWidth: true,
    palettes: [...palettes.values()].filter(d => d.name !== 'Neutral').map(palette => ({
      'data-test-subj': `kbnColoring_ColorMapping_Palette-${palette.id}`,
      value: palette.id,
      title: palette.name,
      palette: Array.from({
        length: palette.colorCount
      }, (_, i) => {
        return palette.getColor(i, isDarkMode, false);
      }),
      type: 'fixed'
    })),
    onChange: selectedPaletteId => {
      const hasChanges = model.assignments.some(a => a.touched);
      const hasGradientChanges = model.colorMode.type === 'gradient' && model.colorMode.steps.some(a => a.touched);
      if (hasChanges || hasGradientChanges) {
        setPreserveModalPaletteId(selectedPaletteId);
      } else {
        switchPaletteFn(selectedPaletteId, false);
      }
    },
    valueOfSelected: model.paletteId,
    selectionDisplay: 'palette',
    compressed: true
  })));
}