"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityFindingFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _is_native_csp_finding = require("../../../common/utils/is_native_csp_finding");
var _take_action = require("../../../components/take_action");
var _helpers = require("../../../../common/utils/helpers");
var _csp_inline_description_list = require("../../../components/csp_inline_description_list");
var _vulnerability_overview_tab = require("./vulnerability_overview_tab");
var _vulnerability_json_tab = require("./vulnerability_json_tab");
var _test_subjects = require("../test_subjects");
var _vulnerability_table_tab = require("./vulnerability_table_tab");
var _create_detection_rule_from_vulnerability = require("../utils/create_detection_rule_from_vulnerability");
var _findings_flyout = require("../../configurations/findings_flyout/findings_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overviewTabId = 'vuln-flyout-overview-tab';
const tableTabId = 'vuln-flyout-table-tab';
const jsonTabId = 'vuln-flyout-json-tab';
const getFlyoutDescriptionList = vulnerabilityRecord => {
  var _vulnerabilityRecord$, _vulnerabilityRecord$2, _vulnerabilityRecord$3, _vulnerabilityRecord$4;
  return [((_vulnerabilityRecord$ = vulnerabilityRecord.resource) === null || _vulnerabilityRecord$ === void 0 ? void 0 : _vulnerabilityRecord$.id) && {
    title: _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.resourceId', {
      defaultMessage: 'Resource ID'
    }),
    description: vulnerabilityRecord.resource.id
  }, ((_vulnerabilityRecord$2 = vulnerabilityRecord.resource) === null || _vulnerabilityRecord$2 === void 0 ? void 0 : _vulnerabilityRecord$2.name) && {
    title: _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.resourceName', {
      defaultMessage: 'Resource Name'
    }),
    description: vulnerabilityRecord.resource.name
  }, ((_vulnerabilityRecord$3 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$3 === void 0 ? void 0 : _vulnerabilityRecord$3.name) && {
    title: _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.packageTitle', {
      defaultMessage: 'Package'
    }),
    description: vulnerabilityRecord.package.name
  }, ((_vulnerabilityRecord$4 = vulnerabilityRecord.package) === null || _vulnerabilityRecord$4 === void 0 ? void 0 : _vulnerabilityRecord$4.version) && {
    title: _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.versionTitle', {
      defaultMessage: 'Version'
    }),
    description: vulnerabilityRecord.package.version
  }].filter(_helpers.truthy);
};
const VulnerabilityFindingFlyout = ({
  closeFlyout,
  vulnerabilityRecord,
  onPaginate,
  totalVulnerabilitiesCount,
  flyoutIndex,
  isLoading = false
}) => {
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(overviewTabId);
  const vulnerability = vulnerabilityRecord === null || vulnerabilityRecord === void 0 ? void 0 : vulnerabilityRecord.vulnerability;
  const tabs = (0, _react.useMemo)(() => [{
    id: overviewTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.overviewTabLabel",
      defaultMessage: "Overview"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_overview_tab.VulnerabilityOverviewTab, {
      vulnerabilityRecord: vulnerabilityRecord
    })
  }, {
    id: tableTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.tableTabLabel",
      defaultMessage: "Table"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_table_tab.VulnerabilityTableTab, {
      vulnerabilityRecord: vulnerabilityRecord
    })
  }, {
    id: jsonTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.jsonTabLabel",
      defaultMessage: "JSON"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_json_tab.VulnerabilityJsonTab, {
      vulnerabilityRecord: vulnerabilityRecord
    })
  }], [vulnerabilityRecord]);
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const renderTabs = () => tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": (0, _test_subjects.TAB_ID_VULNERABILITY_FLYOUT)(tab.id),
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index
  }, tab.name));
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  const LOADING_ARIA_LABEL = _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.loadingAriaLabel', {
    defaultMessage: 'Loading'
  });
  const vulnerabilityReference = vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.reference;
  const createVulnerabilityRuleFn = async http => await (0, _create_detection_rule_from_vulnerability.createDetectionRuleFromVulnerabilityFinding)(http, vulnerabilityRecord);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    size: "m",
    isLoading: isLoading,
    contentAriaLabel: LOADING_ARIA_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: (0, _react2.css)`
              gap: ${_uiTheme.euiThemeVars.euiSizeS};
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.SeverityStatusBadge, {
    severity: vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.severity
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: (0, _react2.css)`
                  gap: ${_uiTheme.euiThemeVars.euiSizeS};
                `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    css: (0, _react2.css)`
                      color: ${_uiTheme.euiThemeVars.euiColorPrimaryText};
                      line-height: 32px;
                    `
  }, vulnerabilityReference ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    href: vulnerabilityReference
  }, vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                      line-height: 20px;
                      margin-bottom: ${_uiTheme.euiThemeVars.euiSizeM};
                    `
  }, /*#__PURE__*/_react.default.createElement(_csp_inline_description_list.CspInlineDescriptionList, {
    testId: _test_subjects.FINDINGS_VULNERABILITY_FLYOUT_DESCRIPTION_LIST,
    listItems: getFlyoutDescriptionList(vulnerabilityRecord)
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, renderTabs()))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    size: "m",
    isLoading: isLoading,
    contentAriaLabel: LOADING_ARIA_LABEL
  }, !(0, _is_native_csp_finding.isNativeCspFinding)(vulnerabilityRecord) && selectedTabId === overviewTabId && /*#__PURE__*/_react.default.createElement("div", {
    style: {
      marginBottom: _uiTheme.euiThemeVars.euiSize
    }
  }, /*#__PURE__*/_react.default.createElement(_findings_flyout.MissingFieldsCallout, {
    finding: vulnerabilityRecord
  })), selectedTabContent)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    justifyContent: onPaginate ? 'spaceBetween' : 'flexEnd'
  }, onPaginate && totalVulnerabilitiesCount && flyoutIndex && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: totalVulnerabilitiesCount,
    activePage: flyoutIndex,
    onPageClick: onPaginate,
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
    createRuleFn: createVulnerabilityRuleFn
  })))));
};
exports.VulnerabilityFindingFlyout = VulnerabilityFindingFlyout;