"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLatestVulnerabilitiesTable = void 0;
var _react = require("react");
var _constants = require("../../../common/constants");
var _use_cloud_posture_data_table = require("../../../common/hooks/use_cloud_posture_data_table");
var _use_latest_vulnerabilities = require("./use_latest_vulnerabilities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columnsLocalStorageKey = 'cloudPosture:latestVulnerabilities:columns';
const useLatestVulnerabilitiesTable = ({
  getDefaultQuery,
  nonPersistedFilters
}) => {
  const cloudPostureDataTable = (0, _use_cloud_posture_data_table.useCloudPostureDataTable)({
    paginationLocalStorageKey: _constants.LOCAL_STORAGE_DATA_TABLE_PAGE_SIZE_KEY,
    columnsLocalStorageKey,
    defaultQuery: getDefaultQuery,
    nonPersistedFilters
  });
  const {
    query,
    sort,
    queryError,
    getRowsFromPages,
    pageSize
  } = cloudPostureDataTable;
  const {
    data,
    error: fetchError,
    isFetching,
    fetchNextPage
  } = (0, _use_latest_vulnerabilities.useLatestVulnerabilities)({
    query,
    sort,
    enabled: !queryError,
    pageSize
  });
  const rows = (0, _react.useMemo)(() => getRowsFromPages(data === null || data === void 0 ? void 0 : data.pages), [data === null || data === void 0 ? void 0 : data.pages, getRowsFromPages]);
  const total = (data === null || data === void 0 ? void 0 : data.pages[0].total) || 0;
  const error = fetchError || queryError;
  return {
    cloudPostureDataTable,
    rows,
    error,
    isFetching,
    fetchNextPage,
    total
  };
};
exports.useLatestVulnerabilitiesTable = useLatestVulnerabilitiesTable;