"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getVendorName = exports.WIZ_VULN_DATASET = exports.WIZ_MISCONFIGURATIONS_DATASET = exports.CSP_VULN_DATASET = exports.CSP_MISCONFIGURATIONS_DATASET = void 0;
var _is_native_csp_finding = require("./is_native_csp_finding");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CSP_MISCONFIGURATIONS_DATASET = exports.CSP_MISCONFIGURATIONS_DATASET = 'cloud_security_posture.findings';
const CSP_VULN_DATASET = exports.CSP_VULN_DATASET = 'cloud_security_posture.vulnerabilities';
const WIZ_MISCONFIGURATIONS_DATASET = exports.WIZ_MISCONFIGURATIONS_DATASET = 'wiz.cloud_configuration_finding';
const WIZ_VULN_DATASET = exports.WIZ_VULN_DATASET = 'wiz.vulnerability';
const getVendorName = finding => {
  var _finding$observer, _finding$data_stream;
  if ((_finding$observer = finding.observer) !== null && _finding$observer !== void 0 && _finding$observer.vendor) return finding.observer.vendor;
  const dataset = (_finding$data_stream = finding.data_stream) === null || _finding$data_stream === void 0 ? void 0 : _finding$data_stream.dataset;
  if (dataset === WIZ_MISCONFIGURATIONS_DATASET || dataset === WIZ_VULN_DATASET) return 'Wiz';
  if ((0, _is_native_csp_finding.isNativeCspFinding)(finding)) return 'Elastic';
};
exports.getVendorName = getVendorName;