"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGeneralView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _styles = require("./styles");
var _utils = require("../../common/utils");
var _helpers = require("../../../common/utils/helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _control_general_view_selector = require("../control_general_view_selector");
var _control_general_view_response = require("../control_general_view_response");
var _constants2 = require("../../common/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * dual purpose button for adding selectors and responses by type
 */
const AddButton = ({
  type,
  onSelectType,
  selectors,
  responses
}) => {
  const totalsByType = (0, _react.useMemo)(() => (0, _utils.getTotalsByType)(selectors, responses), [responses, selectors]);
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const addFile = (0, _react.useCallback)(() => {
    closePopover();
    onSelectType('file');
  }, [onSelectType]);
  const addProcess = (0, _react.useCallback)(() => {
    closePopover();
    onSelectType('process');
  }, [onSelectType]);
  const isSelector = type === 'Selector';
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `addFile${type}`,
    icon: "document",
    onClick: addFile,
    disabled: totalsByType.file >= _constants2.MAX_SELECTORS_AND_RESPONSES_PER_TYPE,
    "data-test-subj": `cloud-defend-btnAddFile${type}`
  }, isSelector ? i18n.fileSelector : i18n.fileResponse), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `addProcess${type}`,
    icon: "gear",
    onClick: addProcess,
    disabled: totalsByType.process >= _constants2.MAX_SELECTORS_AND_RESPONSES_PER_TYPE,
    "data-test-subj": `cloud-defend-btnAddProcess${type}`
  }, isSelector ? i18n.processSelector : i18n.processResponse), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `addNetwork${type}`,
    icon: "globe",
    disabled: true,
    "data-test-subj": `cloud-defend-btnAddNetwork${type}`
  }, isSelector ? i18n.networkSelector : i18n.networkResponse)];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: `btnAdd${type}`,
    display: "block",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fullWidth: true,
      color: "primary",
      iconType: "plusInCircle",
      onClick: onButtonClick,
      "data-test-subj": `cloud-defend-btnAdd${type}`
    }, isSelector ? i18n.addSelector : i18n.addResponse),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items
  }));
};
const ControlGeneralView = ({
  policy,
  onChange,
  show
}) => {
  var _input$vars, _input$vars$configura, _input$vars3;
  const styles = (0, _styles.useStyles)();
  const input = (0, _helpers.getInputFromPolicy)(policy, _constants.INPUT_CONTROL);
  const configuration = (input === null || input === void 0 ? void 0 : (_input$vars = input.vars) === null || _input$vars === void 0 ? void 0 : (_input$vars$configura = _input$vars.configuration) === null || _input$vars$configura === void 0 ? void 0 : _input$vars$configura.value) || '';
  const {
    selectors,
    responses
  } = (0, _react.useMemo)(() => {
    return (0, _helpers.getSelectorsAndResponsesFromYaml)(configuration);
  }, [configuration]);
  const onUpdateYaml = (0, _react.useCallback)((newSelectors, newResponses) => {
    var _input$vars2;
    if (input !== null && input !== void 0 && (_input$vars2 = input.vars) !== null && _input$vars2 !== void 0 && _input$vars2.configuration) {
      const isValid = !newSelectors.find(selector => selector.hasErrors) && !newResponses.find(response => response.hasErrors);
      input.vars.configuration.value = (0, _helpers.getYamlFromSelectorsAndResponses)(newSelectors, newResponses);
      onChange({
        isValid,
        updatedPolicy: {
          ...policy
        }
      });
    }
  }, [input === null || input === void 0 ? void 0 : (_input$vars3 = input.vars) === null || _input$vars3 === void 0 ? void 0 : _input$vars3.configuration, onChange, policy]);
  const incrementName = (0, _react.useCallback)(name => {
    // increment name using ints
    const numberSuffix = name.search(/\d+$/);
    const newName = numberSuffix !== -1 ? name.slice(0, numberSuffix) + (parseInt(name.slice(numberSuffix), 10) + 1) : name + '1';
    const dupe = selectors.find(selector => selector.name === newName);
    if (dupe) {
      return incrementName(dupe.name);
    }
    return newName;
  }, [selectors]);
  const onAddSelector = (0, _react.useCallback)(type => {
    const newSelector = (0, _utils.getDefaultSelectorByType)(type);
    const dupe = selectors.find(selector => selector.name === newSelector.name);
    if (dupe) {
      newSelector.name = incrementName(dupe.name);
    }
    selectors.push(newSelector);
    onUpdateYaml(selectors, responses);
  }, [incrementName, onUpdateYaml, responses, selectors]);
  const onAddResponse = (0, _react.useCallback)(type => {
    const newResponse = (0, _utils.getDefaultResponseByType)(type);
    responses.push(newResponse);
    onUpdateYaml(selectors, responses);
  }, [onUpdateYaml, responses, selectors]);
  const onDuplicateSelector = (0, _react.useCallback)(selector => {
    const duplicate = JSON.parse(JSON.stringify(selector));
    duplicate.name = incrementName(duplicate.name);
    selectors.push(duplicate);
    onUpdateYaml(selectors, responses);
  }, [incrementName, onUpdateYaml, responses, selectors]);
  const onRemoveSelector = (0, _react.useCallback)(index => {
    const oldName = selectors[index].name;
    const newSelectors = [...selectors];
    newSelectors.splice(index, 1);

    // remove reference from all responses
    const updatedResponses = responses.map(r => {
      const response = {
        ...r
      };
      const matchIndex = response.match.indexOf(oldName);
      if (matchIndex !== -1) {
        response.match.splice(matchIndex, 1);
      }
      if (response.exclude) {
        const excludeIndex = response.exclude.indexOf(oldName);
        if (excludeIndex !== -1) {
          response.exclude.splice(excludeIndex, 1);
        }
      }
      return response;
    });
    onUpdateYaml(newSelectors, updatedResponses);
  }, [onUpdateYaml, responses, selectors]);
  const onDuplicateResponse = (0, _react.useCallback)(response => {
    const duplicate = {
      ...response
    };
    responses.push(duplicate);
    onUpdateYaml(selectors, responses);
  }, [onUpdateYaml, responses, selectors]);
  const onRemoveResponse = (0, _react.useCallback)(index => {
    const newResponses = [...responses];
    newResponses.splice(index, 1);
    onUpdateYaml(selectors, newResponses);
  }, [onUpdateYaml, responses, selectors]);
  const onSelectorChange = (0, _react.useCallback)((updatedSelector, index) => {
    const old = selectors[index];
    if (updatedSelector.hasErrors === false) {
      delete updatedSelector.hasErrors;
    }
    const updatedSelectors = JSON.parse(JSON.stringify(selectors));
    let updatedResponses = JSON.parse(JSON.stringify(responses));
    if (old.name !== updatedSelector.name) {
      // update all references to this selector in responses
      updatedResponses = responses.map(response => {
        let oldNameIndex = response.match.indexOf(old.name);
        if (oldNameIndex !== -1) {
          response.match[oldNameIndex] = updatedSelector.name;
        }
        if (response.exclude) {
          oldNameIndex = response.exclude.indexOf(old.name);
          if (oldNameIndex !== -1) {
            response.exclude[oldNameIndex] = updatedSelector.name;
          }
        }
        return response;
      });
    }
    updatedSelectors[index] = JSON.parse(JSON.stringify(updatedSelector));
    onUpdateYaml(updatedSelectors, updatedResponses);
  }, [onUpdateYaml, responses, selectors]);
  const onResponseChange = (0, _react.useCallback)((updatedResponse, index) => {
    if (updatedResponse.hasErrors === false) {
      delete updatedResponse.hasErrors;
    }
    const updatedResponses = JSON.parse(JSON.stringify(responses));
    updatedResponses[index] = JSON.parse(JSON.stringify(updatedResponse));
    onUpdateYaml(selectors, updatedResponses);
  }, [onUpdateYaml, responses, selectors]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: !show && styles.hide,
    gutterSize: "m",
    direction: "column",
    "data-test-subj": "cloud-defend-generalview"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.selectors)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, i18n.selectorsHelp)), selectors.map((selector, i) => {
    const usedByResponse = !!responses.find(response => {
      var _response$exclude;
      return response.match.includes(selector.name) || (response === null || response === void 0 ? void 0 : (_response$exclude = response.exclude) === null || _response$exclude === void 0 ? void 0 : _response$exclude.includes(selector.name));
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: i
    }, /*#__PURE__*/_react.default.createElement(_control_general_view_selector.ControlGeneralViewSelector, {
      key: i,
      index: i,
      selector: selector,
      selectors: selectors,
      usedByResponse: usedByResponse,
      onDuplicate: onDuplicateSelector,
      onRemove: onRemoveSelector,
      onChange: onSelectorChange
    }));
  }), /*#__PURE__*/_react.default.createElement(AddButton, {
    type: "Selector",
    onSelectType: onAddSelector,
    selectors: selectors,
    responses: responses
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.responses)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, i18n.responsesHelp)), responses.map((response, i) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: i
    }, /*#__PURE__*/_react.default.createElement(_control_general_view_response.ControlGeneralViewResponse, {
      index: i,
      response: response,
      responses: responses,
      selectors: selectors,
      onRemove: onRemoveResponse,
      onDuplicate: onDuplicateResponse,
      onChange: onResponseChange
    }));
  }), /*#__PURE__*/_react.default.createElement(AddButton, {
    type: "Response",
    onSelectType: onAddResponse,
    selectors: selectors,
    responses: responses
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.ControlGeneralView = ControlGeneralView;