"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyColorsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _mapped_colors = require("../mapped_colors");
var _colors = require("../../static/colors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Accepts an array of strings or numbers that are used to create a
 * a lookup table that associates the values (key) with a hex color (value).
 * Returns a function that accepts a value (i.e. a string or number)
 * and returns a hex color associated with that value.
 */
class LegacyColorsService {
  constructor() {
    (0, _defineProperty2.default)(this, "_mappedColors", void 0);
    (0, _defineProperty2.default)(this, "seedColors", _colors.seedColors);
  }
  get mappedColors() {
    if (!this._mappedColors) {
      throw new Error('ColorService not yet initialized');
    }
    return this._mappedColors;
  }
  init(uiSettings) {
    this._mappedColors = new _mapped_colors.MappedColors(uiSettings);
  }
  createColorLookupFunction(arrayOfStringsOrNumbers, colorMapping = {}) {
    if (!Array.isArray(arrayOfStringsOrNumbers)) {
      throw new Error(`createColorLookupFunction expects an array but recived: ${typeof arrayOfStringsOrNumbers}`);
    }
    arrayOfStringsOrNumbers.forEach(function (val) {
      if (!_lodash.default.isString(val) && !_lodash.default.isNumber(val) && !_lodash.default.isUndefined(val)) {
        throw new TypeError('createColorLookupFunction expects an array of strings, numbers, or undefined values');
      }
    });
    this.mappedColors.mapKeys(arrayOfStringsOrNumbers);
    return value => {
      return colorMapping[value] || this.mappedColors.get(value);
    };
  }
}
exports.LegacyColorsService = LegacyColorsService;