"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.palette = palette;
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function palette() {
  return {
    name: 'palette',
    aliases: [],
    type: 'palette',
    inputTypes: ['null'],
    help: _i18n.i18n.translate('charts.functions.paletteHelpText', {
      defaultMessage: 'Creates a color palette.'
    }),
    args: {
      color: {
        aliases: ['_'],
        multi: true,
        types: ['string'],
        help: _i18n.i18n.translate('charts.functions.palette.args.colorHelpText', {
          defaultMessage: 'The palette colors. Accepts an {html} color name, {hex}, {hsl}, {hsla}, {rgb}, or {rgba}.',
          values: {
            html: 'HTML',
            rgb: 'RGB',
            rgba: 'RGBA',
            hex: 'HEX',
            hsl: 'HSL',
            hsla: 'HSLA'
          }
        }),
        required: false
      },
      stop: {
        multi: true,
        types: ['number'],
        help: _i18n.i18n.translate('charts.functions.palette.args.stopHelpText', {
          defaultMessage: 'The palette color stops. When used, it must be associated with each color.'
        }),
        required: false
      },
      continuity: {
        types: ['string'],
        options: ['above', 'below', 'all', 'none'],
        default: 'above',
        help: ''
      },
      rangeMin: {
        types: ['number'],
        help: ''
      },
      rangeMax: {
        types: ['number'],
        help: ''
      },
      range: {
        types: ['string'],
        options: ['number', 'percent'],
        default: 'percent',
        help: ''
      },
      gradient: {
        types: ['boolean'],
        default: false,
        help: _i18n.i18n.translate('charts.functions.palette.args.gradientHelpText', {
          defaultMessage: 'Make a gradient palette where supported?'
        }),
        options: [true, false]
      },
      reverse: {
        types: ['boolean'],
        default: false,
        help: _i18n.i18n.translate('charts.functions.palette.args.reverseHelpText', {
          defaultMessage: 'Reverse the palette?'
        }),
        options: [true, false]
      }
    },
    async fn(...args) {
      /** Build optimization: prevent adding extra code into initial bundle **/
      const {
        paletteExpressionFn
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./palette_fn')));
      return paletteExpressionFn(...args);
    }
  };
}