"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.encode = exports.decode = exports.KbnCbor = void 0;
var _borc = require("borc");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// NOTE: This can possibly be replaced with node-cbor using encode, and decodeFirstSync if we do need
// to change into something better maintained but for now we are going to stick with borc as it is
// a little faster

class KbnCbor {
  static encode(data) {
    return (0, _borc.encode)(data);
  }
  static decode(uint8) {
    return (0, _borc.decode)(uint8);
  }
}
exports.KbnCbor = KbnCbor;
const encode = exports.encode = KbnCbor.encode;
const decode = exports.decode = KbnCbor.decode;