"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusColor = exports.getSeverityColor = exports.assigneesTemplateRenderer = void 0;
var _fs = _interopRequireDefault(require("fs"));
var _mustache = _interopRequireDefault(require("mustache"));
var _path = require("path");
var _eui = require("@elastic/eui");
var _domain = require("../../../../../common/types/domain");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TAG_LIMIT = 3;
const DESCRIPTION_LIMIT = 300;
const getStatusColor = status => {
  if (!status) {
    return '#FFF';
  }
  switch (status) {
    case _domain.CaseStatuses.open:
      return '#0077CC';
    case _domain.CaseStatuses['in-progress']:
      return '#FEC514';
    case _domain.CaseStatuses.closed:
      return '#D3DAE6';
    default:
      return (0, _eui.assertNever)(status);
  }
};
exports.getStatusColor = getStatusColor;
const getSeverityColor = severity => {
  if (!severity) {
    return '#FFF';
  }
  switch (severity) {
    case _domain.CaseSeverity.LOW:
      return '#54B399';
    case _domain.CaseSeverity.MEDIUM:
      return '#D6BF57';
    case _domain.CaseSeverity.HIGH:
      return '#DA8B45';
    case _domain.CaseSeverity.CRITICAL:
      return '#E7664C';
    default:
      return (0, _eui.assertNever)(severity);
  }
};
exports.getSeverityColor = getSeverityColor;
const assigneesTemplateRenderer = async (caseData, caseUrl) => {
  const fileDir = (0, _path.join)('.', 'assignees');
  const fileName = 'template.html';
  const dataPath = (0, _utils.getTemplateFilePath)(fileDir, fileName);
  const content = await _fs.default.promises.readFile(dataPath, 'utf8');
  const hasMoreTags = caseData.attributes.tags.length > TAG_LIMIT;
  const numOfExtraTags = Math.max(caseData.attributes.tags.length - TAG_LIMIT, 0);
  const template = _mustache.default.render(content, {
    title: caseData.attributes.title,
    status: caseData.attributes.status,
    statusColor: getStatusColor(caseData.attributes.status),
    severity: caseData.attributes.severity,
    severityColor: getSeverityColor(caseData.attributes.severity),
    hasMoreTags: hasMoreTags ? numOfExtraTags : null,
    tags: caseData.attributes.tags.slice(0, TAG_LIMIT),
    description: caseData.attributes.description.length > DESCRIPTION_LIMIT ? `${caseData.attributes.description.slice(0, DESCRIPTION_LIMIT)}...` : caseData.attributes.description,
    url: caseUrl,
    currentYear: new Date().getUTCFullYear()
  });
  return template;
};
exports.assigneesTemplateRenderer = assigneesTemplateRenderer;