"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.casesRulesSavedObjectType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const casesRulesSavedObjectType = exports.casesRulesSavedObjectType = {
  name: _constants.CASE_RULES_SAVED_OBJECT,
  indexPattern: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
  hidden: true,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: false,
    properties: {
      counter: {
        type: 'unsigned_long'
      },
      createdAt: {
        type: 'date'
      },
      /*
      grouping: {
        type: 'flattened',
      },
      */
      rules: {
        properties: {
          id: {
            type: 'keyword'
          }
        }
      },
      updatedAt: {
        type: 'date'
      }
    }
  },
  management: {
    importableAndExportable: false
  },
  modelVersions: {
    '1': {
      changes: [],
      schemas: {
        create: _configSchema.schema.object({
          counter: _configSchema.schema.number(),
          createdAt: _configSchema.schema.string(),
          grouping: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
          rules: _configSchema.schema.arrayOf(_configSchema.schema.object({
            id: _configSchema.schema.string()
          })),
          updatedAt: _configSchema.schema.nullable(_configSchema.schema.string())
        })
      }
    }
  }
};