"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCaseReferenceId = exports.findReferenceId = void 0;
var _constants = require("../../common/constants");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCaseReferenceId = references => {
  return findReferenceId(_constants2.CASE_REF_NAME, _constants.CASE_SAVED_OBJECT, references);
};
exports.getCaseReferenceId = getCaseReferenceId;
const findReferenceId = (name, type, references) => {
  var _references$find;
  return references === null || references === void 0 ? void 0 : (_references$find = references.find(ref => ref.name === name && ref.type === type)) === null || _references$find === void 0 ? void 0 : _references$find.id;
};
exports.findReferenceId = findReferenceId;