"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusCounts = void 0;
var _case = require("../../../../common/types/case");
var _domain = require("../../../../../common/types/domain");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StatusCounts {
  build() {
    return {
      status: {
        terms: {
          field: `${_constants.CASE_SAVED_OBJECT}.attributes.status`,
          size: _domain.caseStatuses.length
        }
      }
    };
  }
  formatResponse(aggregations) {
    var _aggs$status$buckets, _aggs$status, _status$CasePersisted, _status$CasePersisted2, _status$CasePersisted3;
    const aggs = aggregations;
    const buckets = (_aggs$status$buckets = aggs === null || aggs === void 0 ? void 0 : (_aggs$status = aggs.status) === null || _aggs$status === void 0 ? void 0 : _aggs$status.buckets) !== null && _aggs$status$buckets !== void 0 ? _aggs$status$buckets : [];
    const status = {};
    for (const bucket of buckets) {
      status[bucket.key] = bucket.doc_count;
    }
    return {
      status: {
        open: (_status$CasePersisted = status[_case.CasePersistedStatus.OPEN]) !== null && _status$CasePersisted !== void 0 ? _status$CasePersisted : 0,
        inProgress: (_status$CasePersisted2 = status[_case.CasePersistedStatus.IN_PROGRESS]) !== null && _status$CasePersisted2 !== void 0 ? _status$CasePersisted2 : 0,
        closed: (_status$CasePersisted3 = status[_case.CasePersistedStatus.CLOSED]) !== null && _status$CasePersisted3 !== void 0 ? _status$CasePersisted3 : 0
      }
    };
  }
  getName() {
    return 'status';
  }
}
exports.StatusCounts = StatusCounts;