"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCustomFieldsUserActionBuilder = void 0;
var _common = require("../common");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLabelTitle = (customField, customFieldConfiguration) => {
  var _ref, _customFieldConfigura;
  const customFieldValue = customField.value;
  const label = (_ref = (_customFieldConfigura = customFieldConfiguration === null || customFieldConfiguration === void 0 ? void 0 : customFieldConfiguration.label) !== null && _customFieldConfigura !== void 0 ? _customFieldConfigura : customFieldConfiguration === null || customFieldConfiguration === void 0 ? void 0 : customFieldConfiguration.key) !== null && _ref !== void 0 ? _ref : i18n.UNKNOWN;
  if (customFieldValue == null || Array.isArray(customFieldValue) && customFieldValue.length === 0) {
    return i18n.CHANGED_FIELD_TO_EMPTY(label);
  }
  const value = Array.isArray(customFieldValue) ? customFieldValue[0] : customFieldValue;
  return `${i18n.CHANGED_FIELD.toLowerCase()} ${label} ${i18n.TO} "${value}"`;
};
const createCustomFieldsUserActionBuilder = ({
  userAction,
  handleOutlineComment,
  userProfiles,
  casesConfiguration
}) => ({
  build: () => {
    const customFieldsUserAction = userAction;
    if (customFieldsUserAction.payload.customFields.length === 0) {
      return [];
    }
    const customField = customFieldsUserAction.payload.customFields[0];
    const customFieldConfiguration = casesConfiguration.customFields.find(configCustomField => configCustomField.key === customField.key);
    const label = getLabelTitle(customField, customFieldConfiguration);
    const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
      userAction,
      userProfiles,
      handleOutlineComment,
      label,
      icon: 'dot'
    });
    return commonBuilder.build();
  }
});
exports.createCustomFieldsUserActionBuilder = createCustomFieldsUserActionBuilder;