"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRegisteredAttachmentUserActionBuilder = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _types = require("../../../client/attachment_framework/types");
var _timestamp = require("../timestamp");
var _translations = require("./translations");
var _content_toolbar = require("../content_toolbar");
var _hoverable_user_with_avatar_resolver = require("../../user_profiles/hoverable_user_with_avatar_resolver");
var _registered_attachments_property_actions = require("../property_actions/registered_attachments_property_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides a render function for attachment type.
 * memoize uses the first argument as the caching key.
 * The argument is intentionally declared and unused to
 * be able for TS to warn us in case we forgot to provide one.
 */
const getAttachmentRenderer = (0, _lodash.memoize)(cachingKey => {
  let AttachmentElement;
  const renderCallback = (attachmentViewObject, props) => {
    if (!attachmentViewObject.children) return;
    if (!AttachmentElement) {
      AttachmentElement = /*#__PURE__*/_react.default.createElement(attachmentViewObject.children, props);
    } else {
      AttachmentElement = /*#__PURE__*/_react.default.cloneElement(AttachmentElement, props);
    }
    return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
    }, AttachmentElement);
  };
  return renderCallback;
});
const createRegisteredAttachmentUserActionBuilder = ({
  userAction,
  userProfiles,
  attachment,
  registry,
  caseData,
  isLoading,
  getId,
  getAttachmentViewProps,
  handleDeleteComment
}) => ({
  build: () => {
    var _attachmentViewObject, _attachmentViewObject2;
    const attachmentTypeId = getId();
    const isTypeRegistered = registry.has(attachmentTypeId);
    if (!isTypeRegistered) {
      return [{
        username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
          user: attachment.createdBy,
          userProfiles: userProfiles
        }),
        event: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${_translations.DEFAULT_EVENT_ATTACHMENT_TITLE} `, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, attachmentTypeId)),
        className: `comment-${attachment.type}-not-found`,
        'data-test-subj': `comment-${attachment.type}-not-found`,
        timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
          createdAt: userAction.createdAt
        }),
        children: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
          title: _translations.ATTACHMENT_NOT_REGISTERED_ERROR,
          color: "danger",
          iconType: "warning"
        })
      }];
    }
    const attachmentType = registry.get(attachmentTypeId);
    const props = {
      ...getAttachmentViewProps(),
      attachmentId: attachment.id,
      caseData: {
        id: caseData.id,
        title: caseData.title
      }
    };
    const attachmentViewObject = attachmentType.getAttachmentViewObject(props);
    const renderer = getAttachmentRenderer(userAction.id);
    const actions = (_attachmentViewObject = (_attachmentViewObject2 = attachmentViewObject.getActions) === null || _attachmentViewObject2 === void 0 ? void 0 : _attachmentViewObject2.call(attachmentViewObject, props)) !== null && _attachmentViewObject !== void 0 ? _attachmentViewObject : [];
    const [primaryActions, nonPrimaryActions] = (0, _lodash.partition)(actions, 'isPrimary');
    const visiblePrimaryActions = primaryActions.slice(0, 2);
    const nonVisiblePrimaryActions = primaryActions.slice(2, primaryActions.length);
    return [{
      username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
        user: attachment.createdBy,
        userProfiles: userProfiles
      }),
      className: `comment-${attachment.type}-attachment-${attachmentTypeId}`,
      event: attachmentViewObject.event,
      'data-test-subj': `comment-${attachment.type}-${attachmentTypeId}`,
      timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
        createdAt: userAction.createdAt
      }),
      timelineAvatar: attachmentViewObject.timelineAvatar,
      actions: /*#__PURE__*/_react.default.createElement(_content_toolbar.UserActionContentToolbar, {
        id: attachment.id
      }, visiblePrimaryActions.map(action => {
        var _action$color;
        return action.type === _types.AttachmentActionType.BUTTON && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          "data-test-subj": `attachment-${attachmentTypeId}-${attachment.id}`,
          key: `attachment-${attachmentTypeId}-${attachment.id}`
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": action.label,
          iconType: action.iconType,
          color: (_action$color = action.color) !== null && _action$color !== void 0 ? _action$color : 'text',
          onClick: action.onClick,
          "data-test-subj": `attachment-${attachmentTypeId}-${attachment.id}-${action.iconType}`,
          key: `attachment-${attachmentTypeId}-${attachment.id}-${action.iconType}`
        })) || action.type === _types.AttachmentActionType.CUSTOM && action.render();
      }), /*#__PURE__*/_react.default.createElement(_registered_attachments_property_actions.RegisteredAttachmentsPropertyActions, {
        isLoading: isLoading,
        onDelete: () => handleDeleteComment(attachment.id, _translations.DELETE_REGISTERED_ATTACHMENT),
        registeredAttachmentActions: [...nonVisiblePrimaryActions, ...nonPrimaryActions],
        hideDefaultActions: !!attachmentViewObject.hideDefaultActions
      })),
      children: renderer(attachmentViewObject, props)
    }];
  }
});
exports.createRegisteredAttachmentUserActionBuilder = createRegisteredAttachmentUserActionBuilder;