"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VALUE_PLACEHOLDER = exports.SHOWING_OBSERVABLES = exports.SEARCH_PLACEHOLDER = exports.SAVE_OBSERVABLE = exports.REQUIRED_VALUE = exports.PLATINUM_NOTICE = exports.OBSERVABLE_VALUE = exports.OBSERVABLE_TYPE = exports.OBSERVABLE_ACTIONS = exports.OBSERVABLES_TABLE = exports.NO_OBSERVABLES = exports.INVALID_VALUE = exports.INVALID_EMAIL = exports.FIELD_LABEL_VALUE = exports.FIELD_LABEL_TYPE = exports.FIELD_LABEL_DESCRIPTION = exports.EDIT_OBSERVABLE = exports.DELETE_OBSERVABLE_CONFIRM = exports.DELETE_OBSERVABLE = exports.DATE_ADDED = exports.CANCEL = exports.ADD_OBSERVABLE = exports.ADDED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_OBSERVABLE = exports.ADD_OBSERVABLE = _i18n.i18n.translate('xpack.cases.caseView.observables.addObservable', {
  defaultMessage: 'Add observable'
});
const EDIT_OBSERVABLE = exports.EDIT_OBSERVABLE = _i18n.i18n.translate('xpack.cases.caseView.observables.edit', {
  defaultMessage: 'Edit observable'
});
const NO_OBSERVABLES = exports.NO_OBSERVABLES = _i18n.i18n.translate('xpack.cases.caseView.observables.noObservablesAvailable', {
  defaultMessage: 'No observables available'
});
const SHOWING_OBSERVABLES = totalObservables => _i18n.i18n.translate('xpack.cases.caseView.observables.showingObservablesTitle', {
  values: {
    totalObservables
  },
  defaultMessage: 'Showing {totalObservables} {totalObservables, plural, =1 {observable} other {observables}}'
});
exports.SHOWING_OBSERVABLES = SHOWING_OBSERVABLES;
const OBSERVABLES_TABLE = exports.OBSERVABLES_TABLE = _i18n.i18n.translate('xpack.cases.caseView.observables.observablesTable', {
  defaultMessage: 'Observables table'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.caseView.observables.searchPlaceholder', {
  defaultMessage: 'Search observables'
});
const DATE_ADDED = exports.DATE_ADDED = _i18n.i18n.translate('xpack.cases.caseView.observables.dateAdded', {
  defaultMessage: 'Date added'
});
const OBSERVABLE_TYPE = exports.OBSERVABLE_TYPE = _i18n.i18n.translate('xpack.cases.caseView.observables.type', {
  defaultMessage: 'Observable type'
});
const OBSERVABLE_VALUE = exports.OBSERVABLE_VALUE = _i18n.i18n.translate('xpack.cases.caseView.observables.value', {
  defaultMessage: 'Observable value'
});
const OBSERVABLE_ACTIONS = exports.OBSERVABLE_ACTIONS = _i18n.i18n.translate('xpack.cases.caseView.observables.actions', {
  defaultMessage: 'Actions'
});
const DELETE_OBSERVABLE = exports.DELETE_OBSERVABLE = _i18n.i18n.translate('xpack.cases.caseView.observables.delete', {
  defaultMessage: 'Delete observable'
});
const CANCEL = exports.CANCEL = _i18n.i18n.translate('xpack.cases.caseView.observables.cancel', {
  defaultMessage: 'Cancel'
});
const VALUE_PLACEHOLDER = exports.VALUE_PLACEHOLDER = _i18n.i18n.translate('xpack.cases.caseView.observables.valuePlaceholder', {
  defaultMessage: 'Observable value'
});
const DELETE_OBSERVABLE_CONFIRM = exports.DELETE_OBSERVABLE_CONFIRM = _i18n.i18n.translate('xpack.cases.caseView.observables.deleteConfirmation', {
  defaultMessage: 'Are you sure you want to delete this observable?'
});
const SAVE_OBSERVABLE = exports.SAVE_OBSERVABLE = _i18n.i18n.translate('xpack.cases.caseView.observables.save', {
  defaultMessage: 'Save observable'
});
const ADDED = (type, value) => _i18n.i18n.translate('xpack.cases.caseView.observables.added', {
  defaultMessage: 'observable value "{value}" of type {type} added',
  values: {
    type,
    value
  }
});
exports.ADDED = ADDED;
const PLATINUM_NOTICE = exports.PLATINUM_NOTICE = _i18n.i18n.translate('xpack.cases.caseView.observables.platinumNotice', {
  defaultMessage: 'In order to assign observables to cases, you must be subscribed to an Elastic Platinum license'
});
const REQUIRED_VALUE = exports.REQUIRED_VALUE = _i18n.i18n.translate('xpack.cases.caseView.observables.requiredValue', {
  defaultMessage: 'Value is required'
});
const INVALID_VALUE = exports.INVALID_VALUE = _i18n.i18n.translate('xpack.cases.caseView.observables.invalidValue', {
  defaultMessage: 'Value is invalid'
});
const INVALID_EMAIL = exports.INVALID_EMAIL = _i18n.i18n.translate('xpack.cases.caseView.observables.invalidEmail', {
  defaultMessage: 'Value should be a valid email'
});
const FIELD_LABEL_VALUE = exports.FIELD_LABEL_VALUE = _i18n.i18n.translate('xpack.cases.caseView.observables.labelValue', {
  defaultMessage: 'Value'
});
const FIELD_LABEL_DESCRIPTION = exports.FIELD_LABEL_DESCRIPTION = _i18n.i18n.translate('xpack.cases.caseView.observables.labelDescription', {
  defaultMessage: 'Description'
});
const FIELD_LABEL_TYPE = exports.FIELD_LABEL_TYPE = _i18n.i18n.translate('xpack.cases.caseView.observables.labelType', {
  defaultMessage: 'Type'
});