"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilesTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
var _file_name_link = require("./file_name_link");
var _file_actions_popover_button = require("./file_actions_popover_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFilesTableColumns = ({
  caseId,
  showPreview
}) => {
  return [{
    name: i18n.NAME,
    field: 'name',
    'data-test-subj': 'cases-files-table-filename',
    render: (name, file) => /*#__PURE__*/_react.default.createElement(_file_name_link.FileNameLink, {
      file: file,
      showPreview: () => showPreview(file)
    }),
    width: '60%'
  }, {
    name: i18n.TYPE,
    'data-test-subj': 'cases-files-table-filetype',
    render: attachment => {
      return /*#__PURE__*/_react.default.createElement("span", null, (0, _utils.parseMimeType)(attachment.mimeType));
    }
  }, {
    name: i18n.DATE_ADDED,
    field: 'created',
    'data-test-subj': 'cases-files-table-date-added',
    dataType: 'date'
  }, {
    name: i18n.ACTIONS,
    width: '120px',
    actions: [{
      name: i18n.ACTIONS,
      render: theFile => /*#__PURE__*/_react.default.createElement(_file_actions_popover_button.FileActionsPopoverButton, {
        caseId: caseId,
        theFile: theFile
      })
    }]
  }];
};
exports.useFilesTableColumns = useFilesTableColumns;