"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFileType = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _types = require("../../client/attachment_framework/types");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FileAttachmentEvent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./file_attachment_event'))).then(module => ({
  default: module.FileAttachmentEvent
})));
const FileDeleteButton = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./file_delete_button'))).then(module => ({
  default: module.FileDeleteButton
})));
const FileDownloadButton = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./file_download_button'))).then(module => ({
  default: module.FileDownloadButton
})));
function getFileDownloadButton(fileId) {
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(FileDownloadButton, {
    fileId: fileId,
    isIcon: false
  }));
}
function getFileDeleteButton(caseId, fileId) {
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(FileDeleteButton, {
    caseId: caseId,
    fileId: fileId,
    isIcon: false
  }));
}
const getFileAttachmentActions = ({
  caseId,
  fileId
}) => [{
  type: _types.AttachmentActionType.CUSTOM,
  render: () => getFileDownloadButton(fileId),
  isPrimary: false
}, {
  type: _types.AttachmentActionType.CUSTOM,
  render: () => getFileDeleteButton(caseId, fileId),
  isPrimary: false
}];
const getFileAttachmentViewObject = props => {
  const caseId = props.caseData.id;
  const fileId = props.externalReferenceId;
  if (!(0, _utils.isValidFileExternalReferenceMetadata)(props.externalReferenceMetadata)) {
    return {
      event: i18n.ADDED_UNKNOWN_FILE,
      timelineAvatar: 'document',
      getActions: () => [{
        type: _types.AttachmentActionType.CUSTOM,
        render: () => getFileDeleteButton(caseId, fileId),
        isPrimary: false
      }],
      hideDefaultActions: true
    };
  }
  const fileMetadata = props.externalReferenceMetadata.files[0];
  const file = {
    id: fileId,
    ...fileMetadata
  };
  return {
    event: /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
    }, /*#__PURE__*/_react.default.createElement(FileAttachmentEvent, {
      file: file
    })),
    timelineAvatar: (0, _utils.isImage)(file) ? 'image' : 'document',
    getActions: () => getFileAttachmentActions({
      caseId,
      fileId
    }),
    hideDefaultActions: true
  };
};
const getFileType = () => ({
  id: _constants.FILE_ATTACHMENT_TYPE,
  icon: 'document',
  displayName: 'Files',
  getAttachmentViewObject: getFileAttachmentViewObject,
  getAttachmentRemovalObject: () => ({
    event: i18n.REMOVED_FILE
  })
});
exports.getFileType = getFileType;