"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Description = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _utils = require("../markdown_editor/utils");
var i18n = _interopRequireWildcard(require("../user_actions/translations"));
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_lens_draft_comment = require("../markdown_editor/plugins/lens/use_lens_draft_comment");
var _markdown_editor = require("../markdown_editor");
var _schema = require("./schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DESCRIPTION_ID = 'description';
const getFlexGroupCss = ({
  euiTheme,
  isCollapsed,
  hasUnsavedChanges
}) => (0, _react2.css)`
  padding: ${euiTheme.size.s};
  align-items: center;
  ${!isCollapsed ? (0, _react2.css)`
        border-bottom: ${euiTheme.border.thin};
        border-radius: none;
      ` : (0, _react2.css)`
        background: ${euiTheme.colors.lightestShade};
        border-radius: ${euiTheme.border.radius.medium};
        ${hasUnsavedChanges ? (0, _react2.css)`
              border-bottom-left-radius: 0;
              border-bottom-right-radius: 0;
            ` : (0, _react2.css)``}
      `}
`;
const getDraftDescription = (applicationId = '', caseId, commentId) => {
  const draftStorageKey = (0, _utils.getMarkdownEditorStorageKey)({
    appId: applicationId,
    caseId,
    commentId
  });
  return sessionStorage.getItem(draftStorageKey);
};
const isCommentRef = ref => {
  const commentRef = ref;
  return (commentRef === null || commentRef === void 0 ? void 0 : commentRef.setComment) != null;
};
const Description = ({
  caseData,
  onUpdateField,
  isLoadingDescription
}) => {
  const [isCollapsed, setIsCollapsed] = (0, _react.useState)(false);
  const [isEditable, setIsEditable] = (0, _react.useState)(false);
  const descriptionRef = (0, _react.useRef)(null);
  const descriptionMarkdownRef = (0, _react.useRef)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    permissions,
    owner
  } = (0, _use_cases_context.useCasesContext)();
  const {
    clearDraftComment: clearLensDraftComment,
    draftComment: lensDraftComment,
    hasIncomingLensState,
    openLensModal
  } = (0, _use_lens_draft_comment.useLensDraftComment)();
  const handleOnChangeEditable = (0, _react.useCallback)(() => {
    clearLensDraftComment();
    setIsEditable(false);
  }, [setIsEditable, clearLensDraftComment]);
  const handleOnSave = (0, _react.useCallback)(content => {
    onUpdateField({
      key: DESCRIPTION_ID,
      value: content.trim()
    });
    setIsEditable(false);
  }, [onUpdateField, setIsEditable]);
  const toggleCollapse = () => setIsCollapsed(oldValue => !oldValue);
  const draftDescription = getDraftDescription(owner[0], caseData.id, DESCRIPTION_ID);
  if (hasIncomingLensState && lensDraftComment !== null && (lensDraftComment === null || lensDraftComment === void 0 ? void 0 : lensDraftComment.commentId) === DESCRIPTION_ID && !isEditable) {
    setIsEditable(true);
  }
  (0, _react.useEffect)(() => {
    var _descriptionMarkdownR;
    if (isCommentRef(descriptionMarkdownRef.current) && (_descriptionMarkdownR = descriptionMarkdownRef.current.editor) !== null && _descriptionMarkdownR !== void 0 && _descriptionMarkdownR.textarea && lensDraftComment && lensDraftComment.commentId === DESCRIPTION_ID) {
      descriptionMarkdownRef.current.setComment(lensDraftComment.comment);
      if (hasIncomingLensState) {
        openLensModal({
          editorRef: descriptionMarkdownRef.current.editor
        });
      } else {
        clearLensDraftComment();
      }
    }
  }, [clearLensDraftComment, lensDraftComment, hasIncomingLensState, openLensModal]);
  const hasUnsavedChanges = Boolean(draftDescription && draftDescription !== caseData.description && !isLoadingDescription);
  return isEditable ? /*#__PURE__*/_react.default.createElement(_markdown_editor.EditableMarkdown, {
    id: "description",
    "data-test-subj": "description",
    caseId: caseData.id,
    content: caseData.description,
    onChangeEditable: handleOnChangeEditable,
    onSaveContent: handleOnSave,
    editorRef: descriptionRef,
    fieldName: "content",
    formSchema: _schema.schema,
    ref: descriptionMarkdownRef
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasBorder: true,
    "data-test-subj": "description"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: isCollapsed ? 'none' : 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "s",
    css: getFlexGroupCss({
      euiTheme,
      isCollapsed,
      hasUnsavedChanges
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "description-title",
    size: "s"
  }, i18n.DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, permissions.update ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.EDIT_DESCRIPTION,
    iconType: "pencil",
    onClick: () => setIsEditable(true),
    "data-test-subj": "description-edit-icon"
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": isCollapsed ? i18n.EXPAND_DESCRIPTION : i18n.COLLAPSE_DESCRIPTION,
    iconType: isCollapsed ? 'unfold' : 'fold',
    onClick: toggleCollapse,
    "data-test-subj": "description-collapse-icon"
  }))))), !isCollapsed ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              padding: ${euiTheme.size.s};
              padding-top: 0;

              > div {
                padding: 0;
              }
            `
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.ScrollableMarkdown, {
    content: caseData.description
  })) : null, hasUnsavedChanges ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
              border-top: ${euiTheme.border.thin};
              padding: ${euiTheme.size.s};
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "description-unsaved-draft"
  }, i18n.UNSAVED_DRAFT_DESCRIPTION)) : null));
};
exports.Description = Description;
Description.displayName = 'Description';