"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Mapping = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _domain = require("../../../common/types/domain");
var i18n = _interopRequireWildcard(require("./translations"));
var _field_mapping = require("./field_mapping");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MappingComponent = ({
  actionTypeName,
  connectorType,
  isLoading,
  mappings
}) => {
  const fieldMappingDesc = (0, _react.useMemo)(() => mappings.length > 0 || isLoading ? {
    desc: i18n.FIELD_MAPPING_DESC(actionTypeName),
    color: 'subdued'
  } : connectorType === _domain.ConnectorTypes.casesWebhook ? {
    desc: i18n.CASES_WEBHOOK_MAPPINGS,
    color: 'subdued'
  } : {
    desc: i18n.FIELD_MAPPING_DESC_ERR(actionTypeName),
    color: 'danger'
  }, [mappings.length, isLoading, actionTypeName, connectorType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": "field-mapping-text"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.FIELD_MAPPING_TITLE(actionTypeName)), /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    "data-test-subj": "field-mapping-desc",
    color: fieldMappingDesc.color
  }, fieldMappingDesc.desc))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_field_mapping.FieldMapping, {
    actionTypeName: actionTypeName,
    "data-test-subj": "case-mappings-field",
    isLoading: isLoading,
    mappings: mappings
  })));
};
MappingComponent.displayName = 'Mapping';
const Mapping = exports.Mapping = /*#__PURE__*/_react.default.memo(MappingComponent);