"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOnUpdateField = void 0;
var _react = require("react");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _use_update_case = require("../../containers/use_update_case");
var _utils = require("../../containers/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOnUpdateField = ({
  caseData
}) => {
  const {
    isLoading,
    mutate: updateCaseProperty
  } = (0, _use_update_case.useUpdateCase)();
  const [loadingKey, setLoadingKey] = (0, _react.useState)(null);
  const onUpdateField = (0, _react.useCallback)(({
    key,
    value,
    onSuccess,
    onError
  }) => {
    const callUpdate = (updateKey, updateValue) => {
      setLoadingKey(updateKey);
      updateCaseProperty({
        updateKey,
        updateValue,
        caseData
      }, {
        onSuccess: () => {
          onSuccess === null || onSuccess === void 0 ? void 0 : onSuccess();
          setLoadingKey(null);
        },
        onError: () => {
          onError === null || onError === void 0 ? void 0 : onError();
          setLoadingKey(null);
        }
      });
    };
    switch (key) {
      case 'title':
        const titleUpdate = (0, _utils.getTypedPayload)(value);
        if (titleUpdate.length > 0) {
          callUpdate('title', titleUpdate);
        }
        break;
      case 'connector':
        const connector = (0, _utils.getTypedPayload)(value);
        if (connector != null) {
          callUpdate('connector', connector);
        }
        break;
      case 'description':
        const descriptionUpdate = (0, _utils.getTypedPayload)(value);
        if (descriptionUpdate.length > 0) {
          callUpdate('description', descriptionUpdate);
        }
        break;
      case 'tags':
        const tagsUpdate = (0, _utils.getTypedPayload)(value);
        callUpdate('tags', tagsUpdate);
        break;
      case 'category':
        const categoryUpdate = (0, _utils.getTypedPayload)(value);
        callUpdate('category', categoryUpdate);
        break;
      case 'status':
        const statusUpdate = (0, _utils.getTypedPayload)(value);
        if (caseData.status !== value) {
          callUpdate('status', statusUpdate);
        }
        break;
      case 'settings':
        const settingsUpdate = (0, _utils.getTypedPayload)(value);
        if (caseData.settings !== value) {
          callUpdate('settings', settingsUpdate);
        }
        break;
      case 'severity':
        const severityUpdate = (0, _utils.getTypedPayload)(value);
        if (caseData.severity !== value) {
          callUpdate('severity', severityUpdate);
        }
        break;
      case 'assignees':
        const assigneesUpdate = (0, _utils.getTypedPayload)(value);
        if (!(0, _fastDeepEqual.default)(caseData.assignees, value)) {
          callUpdate('assignees', assigneesUpdate);
        }
        break;
      case 'customFields':
        const customFields = (0, _utils.getTypedPayload)(value);
        if (!(0, _fastDeepEqual.default)(caseData.customFields, value)) {
          callUpdate('customFields', customFields);
        }
        break;
      default:
        return null;
    }
  }, [updateCaseProperty, caseData]);
  return {
    onUpdateField,
    isLoading,
    loadingKey
  };
};
exports.useOnUpdateField = useOnUpdateField;