"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringifyUrlParams = stringifyUrlParams;
var _rison = require("@kbn/rison");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function stringifyUrlParams(allCasesUrlParams, currentSearch = '') {
  const encodedUrlParams = (0, _rison.encode)({
    ...allCasesUrlParams
  });
  const searchUrlParams = removeLegacyStateFromUrl(new URLSearchParams(decodeURIComponent(currentSearch)));
  searchUrlParams.delete(_constants.ALL_CASES_STATE_URL_KEY);
  const casesQueryParam = `${_constants.ALL_CASES_STATE_URL_KEY}=${encodedUrlParams}`;
  return searchUrlParams.size > 0 ? `${casesQueryParam}&${searchUrlParams.toString()}` : casesQueryParam;
}
const removeLegacyStateFromUrl = urlParams => {
  const newUrlParams = new URLSearchParams(urlParams);
  _constants.LEGACY_SUPPORTED_STATE_KEYS.forEach(key => newUrlParams.delete(key));
  return newUrlParams;
};