"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsUserTyping = void 0;
var _lodash = require("lodash");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsUserTyping = () => {
  const [isUserTyping, setIsUserTyping] = (0, _react.useState)(false);
  const onDebounce = (0, _react.useCallback)(() => setIsUserTyping(false), []);
  const onContentChange = (0, _react.useCallback)(value => {
    if (!(0, _lodash.isEmpty)(value)) {
      setIsUserTyping(true);
    }
  }, []);
  return {
    isUserTyping,
    setIsUserTyping,
    onDebounce,
    onContentChange
  };
};
exports.useIsUserTyping = useIsUserTyping;