"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleIdFromEvent = getRuleIdFromEvent;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getRuleIdFromEvent(event) {
  var _ref, _ref2, _ref3, _ref4;
  const ruleUuidData = event && event.data.find(({
    field
  }) => field === _ruleDataUtils.ALERT_RULE_UUID);
  const ruleNameData = event && event.data.find(({
    field
  }) => field === _ruleDataUtils.ALERT_RULE_NAME);
  const ruleUuidValueData = ruleUuidData && ruleUuidData.value && ruleUuidData.value[0];
  const ruleNameValueData = ruleNameData && ruleNameData.value && ruleNameData.value[0];
  const ruleUuid = (_ref = (_ref2 = ruleUuidValueData !== null && ruleUuidValueData !== void 0 ? ruleUuidValueData : (0, _fp.get)(`ecs.${_ruleDataUtils.ALERT_RULE_UUID}[0]`, event)) !== null && _ref2 !== void 0 ? _ref2 : (0, _fp.get)(`ecs.signal.rule.id[0]`, event)) !== null && _ref !== void 0 ? _ref : null;
  const ruleName = (_ref3 = (_ref4 = ruleNameValueData !== null && ruleNameValueData !== void 0 ? ruleNameValueData : (0, _fp.get)(`ecs.${_ruleDataUtils.ALERT_RULE_NAME}[0]`, event)) !== null && _ref4 !== void 0 ? _ref4 : (0, _fp.get)(`ecs.signal.rule.name[0]`, event)) !== null && _ref3 !== void 0 ? _ref3 : null;
  return {
    id: ruleUuid,
    name: ruleName
  };
}