"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetCaseConnectorsResponseRt = exports.FindActionConnectorResponseRt = exports.ConnectorMappingResponseRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _v = require("../../domain/external_service/v1");
var _v2 = require("../../domain/connector/v1");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PushDetailsRt = rt.strict({
  latestUserActionPushDate: rt.string,
  oldestUserActionPushDate: rt.string,
  externalService: _v.ExternalServiceRt
});
const CaseConnectorPushInfoRt = rt.intersection([rt.strict({
  needsToBePushed: rt.boolean,
  hasBeenPushed: rt.boolean
}), rt.exact(rt.partial({
  details: PushDetailsRt
}))]);
const GetCaseConnectorsResponseRt = exports.GetCaseConnectorsResponseRt = rt.record(rt.string, rt.intersection([rt.strict({
  push: CaseConnectorPushInfoRt
}), _v2.CaseConnectorRt]));
const ActionConnectorResultRt = rt.intersection([rt.strict({
  id: rt.string,
  actionTypeId: rt.string,
  name: rt.string,
  isDeprecated: rt.boolean,
  isPreconfigured: rt.boolean,
  isSystemAction: rt.boolean,
  referencedByCount: rt.number
}), rt.exact(rt.partial({
  config: rt.record(rt.string, rt.unknown),
  isMissingSecrets: rt.boolean
}))]);
const FindActionConnectorResponseRt = exports.FindActionConnectorResponseRt = rt.array(ActionConnectorResultRt);
const ConnectorMappingResponseRt = exports.ConnectorMappingResponseRt = rt.strict({
  id: rt.string,
  version: rt.string,
  mappings: _v2.ConnectorMappingsRt
});