"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToggleCustomFieldConfigurationRt = exports.TextCustomFieldConfigurationRt = exports.TemplatesConfigurationRt = exports.TemplateConfigurationRt = exports.ObservableTypesConfigurationRt = exports.NumberCustomFieldConfigurationRt = exports.GetConfigurationFindRequestRt = exports.CustomFieldsConfigurationRt = exports.CustomFieldConfigurationWithoutTypeRt = exports.ConfigurationRequestRt = exports.ConfigurationPatchRequestRt = exports.CaseConfigureRequestParamsRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _constants = require("../../../constants");
var _schema = require("../../../schema");
var _domain = require("../../domain");
var _v = require("../../domain/configure/v1");
var _v2 = require("../../domain/connector/v1");
var _v3 = require("../case/v1");
var _v4 = require("../custom_field/v1");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CustomFieldConfigurationWithoutTypeRt = exports.CustomFieldConfigurationWithoutTypeRt = rt.strict({
  /**
   * key of custom field
   */
  key: (0, _schema.regexStringRt)({
    codec: (0, _schema.limitedStringSchema)({
      fieldName: 'key',
      min: 1,
      max: _constants.MAX_CUSTOM_FIELD_KEY_LENGTH
    }),
    pattern: '^[a-z0-9_-]+$',
    message: `Key must be lower case, a-z, 0-9, '_', and '-' are allowed`
  }),
  /**
   * label of custom field
   */
  label: (0, _schema.limitedStringSchema)({
    fieldName: 'label',
    min: 1,
    max: _constants.MAX_CUSTOM_FIELD_LABEL_LENGTH
  }),
  /**
   * custom field options - required
   */
  required: rt.boolean
});
const TextCustomFieldConfigurationRt = exports.TextCustomFieldConfigurationRt = rt.intersection([rt.strict({
  type: _domain.CustomFieldTextTypeRt
}), CustomFieldConfigurationWithoutTypeRt, rt.exact(rt.partial({
  defaultValue: rt.union([(0, _v4.CaseCustomFieldTextWithValidationValueRt)('defaultValue'), rt.null])
}))]);
const ToggleCustomFieldConfigurationRt = exports.ToggleCustomFieldConfigurationRt = rt.intersection([rt.strict({
  type: _domain.CustomFieldToggleTypeRt
}), CustomFieldConfigurationWithoutTypeRt, rt.exact(rt.partial({
  defaultValue: rt.union([rt.boolean, rt.null])
}))]);
const NumberCustomFieldConfigurationRt = exports.NumberCustomFieldConfigurationRt = rt.intersection([rt.strict({
  type: _domain.CustomFieldNumberTypeRt
}), CustomFieldConfigurationWithoutTypeRt, rt.exact(rt.partial({
  defaultValue: rt.union([(0, _v4.CaseCustomFieldNumberWithValidationValueRt)({
    fieldName: 'defaultValue'
  }), rt.null])
}))]);
const CustomFieldsConfigurationRt = exports.CustomFieldsConfigurationRt = (0, _schema.limitedArraySchema)({
  codec: rt.union([TextCustomFieldConfigurationRt, ToggleCustomFieldConfigurationRt, NumberCustomFieldConfigurationRt]),
  min: 0,
  max: _constants.MAX_CUSTOM_FIELDS_PER_CASE,
  fieldName: 'customFields'
});
const ObservableTypesConfigurationRt = exports.ObservableTypesConfigurationRt = (0, _schema.limitedArraySchema)({
  min: 0,
  max: _constants.MAX_CUSTOM_OBSERVABLE_TYPES,
  fieldName: 'observableTypes',
  codec: rt.strict({
    key: (0, _schema.regexStringRt)({
      codec: (0, _schema.limitedStringSchema)({
        fieldName: 'key',
        min: 1,
        max: _constants.MAX_OBSERVABLE_TYPE_KEY_LENGTH
      }),
      pattern: '^[a-z0-9_-]+$',
      message: `Key must be lower case, a-z, 0-9, '_', and '-' are allowed`
    }),
    label: (0, _schema.limitedStringSchema)({
      fieldName: 'label',
      min: 1,
      max: _constants.MAX_OBSERVABLE_TYPE_LABEL_LENGTH
    })
  })
});
const TemplateConfigurationRt = exports.TemplateConfigurationRt = rt.intersection([rt.strict({
  /**
   * key of template
   */
  key: (0, _schema.regexStringRt)({
    codec: (0, _schema.limitedStringSchema)({
      fieldName: 'key',
      min: 1,
      max: _constants.MAX_TEMPLATE_KEY_LENGTH
    }),
    pattern: '^[a-z0-9_-]+$',
    message: `Key must be lower case, a-z, 0-9, '_', and '-' are allowed`
  }),
  /**
   * name of template
   */
  name: (0, _schema.limitedStringSchema)({
    fieldName: 'name',
    min: 1,
    max: _constants.MAX_TEMPLATE_NAME_LENGTH
  }),
  /**
   * case fields
   */
  caseFields: rt.union([rt.null, _v3.CaseBaseOptionalFieldsRequestRt])
}), rt.exact(rt.partial({
  /**
   * description of templates
   */
  description: (0, _schema.limitedStringSchema)({
    fieldName: 'description',
    min: 0,
    max: _constants.MAX_TEMPLATE_DESCRIPTION_LENGTH
  }),
  /**
   * tags of templates
   */
  tags: (0, _schema.limitedArraySchema)({
    codec: (0, _schema.limitedStringSchema)({
      fieldName: `template's tag`,
      min: 1,
      max: _constants.MAX_TEMPLATE_TAG_LENGTH
    }),
    min: 0,
    max: _constants.MAX_TAGS_PER_TEMPLATE,
    fieldName: `template's tags`
  })
}))]);
const TemplatesConfigurationRt = exports.TemplatesConfigurationRt = (0, _schema.limitedArraySchema)({
  codec: TemplateConfigurationRt,
  min: 0,
  max: _constants.MAX_TEMPLATES_LENGTH,
  fieldName: 'templates'
});
const ConfigurationRequestRt = exports.ConfigurationRequestRt = rt.intersection([rt.strict({
  /**
   * The external connector
   */
  connector: _v2.CaseConnectorRt,
  /**
   * Whether to close the case after it has been synced with the external system
   */
  closure_type: _v.ClosureTypeRt,
  /**
   * The plugin owner that manages this configuration
   */
  owner: rt.string
}), rt.exact(rt.partial({
  customFields: CustomFieldsConfigurationRt,
  templates: TemplatesConfigurationRt,
  observableTypes: ObservableTypesConfigurationRt
}))]);
const GetConfigurationFindRequestRt = exports.GetConfigurationFindRequestRt = rt.exact(rt.partial({
  /**
   * The configuration plugin owner to filter the search by. If this is left empty the results will include all configurations
   * that the user has permissions to access
   */
  owner: rt.union([rt.array(rt.string), rt.string])
}));
const CaseConfigureRequestParamsRt = exports.CaseConfigureRequestParamsRt = rt.strict({
  configuration_id: rt.string
});
const ConfigurationPatchRequestRt = exports.ConfigurationPatchRequestRt = rt.intersection([rt.exact(rt.partial({
  closure_type: _v.ConfigurationBasicWithoutOwnerRt.type.props.closure_type,
  connector: _v.ConfigurationBasicWithoutOwnerRt.type.props.connector,
  customFields: CustomFieldsConfigurationRt,
  templates: TemplatesConfigurationRt,
  observableTypes: ObservableTypesConfigurationRt
})), rt.strict({
  version: rt.string
})]);