"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workpadReducer = void 0;
var _reduxActions = require("redux-actions");
var _kibana_services = require("../../services/kibana_services");
var _defaults = require("../defaults");
var _constants = require("../../../common/lib/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const workpadReducer = exports.workpadReducer = (0, _reduxActions.handleActions)({
  ['setWorkpad']: (workpadState, {
    payload
  }) => {
    _kibana_services.coreServices.chrome.recentlyAccessed.add(`${_constants.APP_ROUTE_WORKPAD}/${payload.id}`, payload.name, payload.id);
    return payload;
  },
  ['sizeWorkpad']: (workpadState, {
    payload
  }) => {
    return {
      ...workpadState,
      ...payload
    };
  },
  ['setColors']: (workpadState, {
    payload
  }) => {
    return {
      ...workpadState,
      colors: payload
    };
  },
  ['setName']: (workpadState, {
    payload
  }) => {
    _kibana_services.coreServices.chrome.recentlyAccessed.add(`${_constants.APP_ROUTE_WORKPAD}/${workpadState.id}`, payload, workpadState.id);
    return {
      ...workpadState,
      name: payload
    };
  },
  ['setWriteable']: (workpadState, {
    payload
  }) => {
    return {
      ...workpadState,
      isWriteable: Boolean(payload)
    };
  },
  ['setWorkpadCSS']: (workpadState, {
    payload
  }) => {
    return {
      ...workpadState,
      css: payload
    };
  },
  ['setWorkpadVariables']: (workpadState, {
    payload
  }) => {
    return {
      ...workpadState,
      variables: payload
    };
  },
  ['resetWorkpad']: () => ({
    ...(0, _defaults.getDefaultWorkpad)()
  })
}, {});