"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCanvasFiltersService = void 0;
var _store = require("../state/store");
var _workpad = require("../state/selectors/workpad");
var _filters = require("../state/actions/filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

// @ts-expect-error untyped local

class FiltersService {
  getFilters(state = (0, _store.getState)()) {
    return (0, _workpad.getGlobalFilters)(state);
  }
  updateFilter(filterId, filterExpression) {
    const {
      dispatch
    } = (0, _store.getStore)();
    dispatch((0, _filters.setFilter)(filterExpression, filterId));
  }
  getFiltersContext(state = (0, _store.getState)()) {
    const variables = (0, _workpad.getWorkpadVariablesAsObject)(state);
    return {
      variables
    };
  }
}
let canvasFiltersService;
const getCanvasFiltersService = () => {
  if (!canvasFiltersService) {
    canvasFiltersService = new FiltersService();
  }
  return canvasFiltersService;
};
exports.getCanvasFiltersService = getCanvasFiltersService;