"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolTipShortcut = void 0;
var _reactRecompose = require("react-recompose");
var _tool_tip_shortcut = require("./tool_tip_shortcut");
var _get_client_platform = require("../../lib/get_client_platform");
var _keymap = require("../../lib/keymap");
var _get_pretty_shortcut = require("../../lib/get_pretty_shortcut");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const os = (0, _get_client_platform.getClientPlatform)();
const ToolTipShortcut = exports.ToolTipShortcut = (0, _reactRecompose.compose)((0, _reactRecompose.mapProps)(({
  namespace,
  action
}) => {
  const shortcutMap = _keymap.keymap[namespace][action];
  if (typeof shortcutMap === 'string') {
    return {
      shortcut: ''
    };
  }
  const shortcuts = shortcutMap[os] || [];
  return {
    shortcut: (0, _get_pretty_shortcut.getPrettyShortcut)(shortcuts[0])
  };
}))(_tool_tip_shortcut.ToolTipShortcut);