"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionFormContextError = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getContextErrorMessage: (errorMessage = '') => _i18n.i18n.translate('xpack.canvas.functionForm.contextError', {
    defaultMessage: 'ERROR: {errorMessage}',
    values: {
      errorMessage
    }
  })
};
const FunctionFormContextError = ({
  context
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasFunctionForm canvasFunctionForm--error"
}, strings.getContextErrorMessage(context.error));
exports.FunctionFormContextError = FunctionFormContextError;