"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _function_form_component = require("./function_form_component");
var _function_unknown = require("./function_unknown");
var _function_form_context_pending = require("./function_form_context_pending");
var _function_form_context_error = require("./function_form_context_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// helper to check the state of the passed in expression type
function is(state, expressionType, context) {
  const matchState = !context || context.state === state;
  return expressionType && expressionType.requiresContext && matchState;
}
const FunctionForm = props => {
  const {
    expressionType,
    context
  } = props;
  if (!expressionType) {
    return /*#__PURE__*/_react.default.createElement(_function_unknown.FunctionUnknown, {
      argType: props.argType
    });
  }
  if (is('pending', expressionType, context)) {
    return /*#__PURE__*/_react.default.createElement(_function_form_context_pending.FunctionFormContextPending, {
      context: props.context,
      expressionType: props.expressionType,
      updateContext: props.updateContext
    });
  }
  if (is('error', expressionType, context)) {
    return /*#__PURE__*/_react.default.createElement(_function_form_context_error.FunctionFormContextError, {
      context: context !== null && context !== void 0 ? context : {
        state: 'error',
        error: 'Error occured',
        value: expressionType
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_function_form_component.FunctionFormComponent, props);
};
exports.FunctionForm = FunctionForm;