"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Fullscreen = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _get_window = require("../../lib/get_window");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Fullscreen = ({
  isFullscreen = false,
  children
}) => {
  const [width, setWidth] = (0, _react.useState)((0, _get_window.getWindow)().innerWidth);
  const [height, setHeight] = (0, _react.useState)((0, _get_window.getWindow)().innerHeight);
  const onWindowResize = (0, _lodash.debounce)(({
    target
  }) => {
    const {
      innerWidth,
      innerHeight
    } = target;
    setWidth(innerWidth);
    setHeight(innerHeight);
  }, 100);
  (0, _react.useEffect)(() => {
    const window = (0, _get_window.getWindow)();
    window.addEventListener('resize', onWindowResize);
    return () => window.removeEventListener('resize', onWindowResize);
  });
  const windowSize = {
    width,
    height
  };
  return children({
    isFullscreen,
    windowSize
  });
};
exports.Fullscreen = Fullscreen;