"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmModal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfirmModal = props => {
  const {
    isOpen,
    title,
    message,
    onConfirm,
    onCancel,
    confirmButtonText,
    cancelButtonText,
    className,
    ...rest
  } = props;

  // render nothing if this component isn't open
  if (!isOpen) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, (0, _extends2.default)({}, rest, {
    className: `canvasConfirmModal ${className || ''}`,
    title: title,
    onCancel: onCancel,
    onConfirm: onConfirm,
    confirmButtonText: confirmButtonText,
    cancelButtonText: cancelButtonText,
    defaultFocusedButton: "confirm",
    buttonColor: "danger",
    "data-test-subj": "canvasConfirmModal"
  }), message);
};
exports.ConfirmModal = ConfirmModal;
ConfirmModal.propTypes = {
  isOpen: _propTypes.default.bool,
  title: _propTypes.default.string,
  message: _propTypes.default.string.isRequired,
  onConfirm: _propTypes.default.func.isRequired,
  onCancel: _propTypes.default.func.isRequired,
  cancelButtonText: _propTypes.default.string,
  confirmButtonText: _propTypes.default.string,
  className: _propTypes.default.string
};
ConfirmModal.defaultProps = {
  title: 'Confirm',
  confirmButtonText: 'Confirm',
  cancelButtonText: 'Cancel'
};