"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInfoRoute = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerInfoRoute = (router, config) => {
  router.get({
    path: '/api/banners/info',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization'
      }
    },
    validate: false,
    options: {
      authRequired: 'optional'
    }
  }, async (ctx, req, res) => {
    const allowed = isValidLicense((await ctx.licensing).license);
    const bannerConfig = req.auth.isAuthenticated && config.disableSpaceBanners === false ? await getBannerConfig((await ctx.core).uiSettings.client) : config;
    return res.ok({
      body: {
        allowed,
        banner: bannerConfig
      }
    });
  });
};
exports.registerInfoRoute = registerInfoRoute;
const isValidLicense = license => {
  return license.hasAtLeast('gold');
};
const getBannerConfig = async client => {
  const [placement, textContent, textColor, backgroundColor] = await Promise.all([client.get('banners:placement'), client.get('banners:textContent'), client.get('banners:textColor'), client.get('banners:backgroundColor')]);
  return {
    placement,
    textContent,
    textColor,
    backgroundColor
  };
};