"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransactionByName = getTransactionByName;
var _server = require("@kbn/observability-plugin/server");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _maybe2 = require("../../../../common/utils/maybe");
var _document_type = require("../../../../common/document_type");
var _apm = require("../../../../common/es_fields/apm");
var _rollup = require("../../../../common/rollup");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getTransactionByName({
  transactionName,
  serviceName,
  apmEventClient,
  start,
  end
}) {
  var _maybe;
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apm.AT_TIMESTAMP, _apm.TRACE_ID, _apm.TRANSACTION_ID, _apm.TRANSACTION_TYPE, _apm.TRANSACTION_NAME, _apm.TRANSACTION_DURATION, _apm.SERVICE_NAME]);
  const resp = await apmEventClient.search('get_transaction', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.TransactionEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    body: {
      track_total_hits: false,
      size: 1,
      terminate_after: 1,
      query: {
        bool: {
          filter: (0, _as_mutable_array.asMutableArray)([{
            term: {
              [_apm.TRANSACTION_NAME]: transactionName
            }
          }, {
            term: {
              [_apm.SERVICE_NAME]: serviceName
            }
          }, ...(0, _server.rangeQuery)(start, end)])
        }
      },
      fields: requiredFields
    }
  });
  return (0, _utils.unflattenKnownApmEventFields)((_maybe = (0, _maybe2.maybe)(resp.hits.hits[0])) === null || _maybe === void 0 ? void 0 : _maybe.fields, requiredFields);
}