"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeRangeMetadataRoute = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
var _get_is_using_service_destination_metrics = require("../../lib/helpers/spans/get_is_using_service_destination_metrics");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _get_apm_data_access_services = require("../../lib/helpers/get_apm_data_access_services");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timeRangeMetadataRoute = exports.timeRangeMetadataRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/time_range_metadata',
  params: t.type({
    query: t.intersection([t.type({
      useSpanName: _ioTsUtils.toBooleanRt,
      enableServiceTransactionMetrics: _ioTsUtils.toBooleanRt,
      enableContinuousRollups: _ioTsUtils.toBooleanRt
    }), _default_api_types.kueryRt, _default_api_types.rangeRt])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const apmDataAccessServices = await (0, _get_apm_data_access_services.getApmDataAccessServices)({
      apmEventClient,
      ...resources
    });
    const {
      query: {
        useSpanName,
        start,
        end,
        kuery,
        enableServiceTransactionMetrics,
        enableContinuousRollups
      }
    } = resources.params;
    const [isUsingServiceDestinationMetrics, sources] = await Promise.all([(0, _get_is_using_service_destination_metrics.getIsUsingServiceDestinationMetrics)({
      apmEventClient,
      useSpanName,
      start,
      end,
      kuery
    }), apmDataAccessServices.getDocumentSources({
      start,
      end,
      kuery,
      enableServiceTransactionMetrics,
      enableContinuousRollups
    })]);
    return {
      isUsingServiceDestinationMetrics,
      sources
    };
  }
});