"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceNodeMetadata = getServiceNodeMetadata;
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _i18n = require("../../../common/i18n");
var _environment_query = require("../../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getServiceNodeMetadata({
  kuery,
  serviceName,
  serviceNodeName,
  apmEventClient,
  start,
  end,
  environment,
  documentType,
  rollupInterval
}) {
  var _aggregations$host$bu, _aggregations$contain;
  const params = {
    apm: {
      sources: [{
        documentType,
        rollupInterval
      }]
    },
    body: {
      track_total_hits: false,
      size: 0,
      query: {
        bool: {
          filter: [{
            term: {
              [_apm.SERVICE_NAME]: serviceName
            }
          }, ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), ...(0, _environment_query.serviceNodeNameQuery)(serviceNodeName)]
        }
      },
      aggs: {
        nodes: {
          terms: {
            field: _apm.SERVICE_NODE_NAME
          }
        },
        host: {
          terms: {
            field: _apm.HOST_NAME,
            size: 1
          }
        },
        containerId: {
          terms: {
            field: _apm.CONTAINER_ID,
            size: 1
          }
        }
      }
    }
  };
  const {
    aggregations
  } = await apmEventClient.search('get_service_node_metadata', params);
  return {
    host: (aggregations === null || aggregations === void 0 ? void 0 : (_aggregations$host$bu = aggregations.host.buckets[0]) === null || _aggregations$host$bu === void 0 ? void 0 : _aggregations$host$bu.key) || _i18n.NOT_AVAILABLE_LABEL,
    containerId: (aggregations === null || aggregations === void 0 ? void 0 : (_aggregations$contain = aggregations.containerId.buckets[0]) === null || _aggregations$contain === void 0 ? void 0 : _aggregations$contain.key) || _i18n.NOT_AVAILABLE_LABEL
  };
}