"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getObservabilityOverviewData = getObservabilityOverviewData;
var _with_apm_span = require("../../utils/with_apm_span");
var _get_service_count = require("./get_service_count");
var _get_transactions_per_minute = require("./get_transactions_per_minute");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getObservabilityOverviewData({
  apmEventClient,
  start,
  end,
  searchAggregatedTransactions,
  bucketSize,
  intervalString
}) {
  return (0, _with_apm_span.withApmSpan)('observability_overview', async () => {
    const [serviceCount, transactionPerMinute] = await Promise.all([(0, _get_service_count.getServiceCount)({
      apmEventClient,
      searchAggregatedTransactions,
      start,
      end
    }), (0, _get_transactions_per_minute.getTransactionsPerMinute)({
      apmEventClient,
      bucketSize,
      searchAggregatedTransactions,
      start,
      end,
      intervalString
    })]);
    return {
      serviceCount,
      transactionPerMinute
    };
  });
}