"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasOTelMetrics = void 0;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _apm = require("../../../common/es_fields/apm");
var _environment_query = require("../../../common/utils/environment_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasOTelMetrics = async ({
  kuery,
  apmEventClient,
  serviceName,
  environment,
  start,
  end
}) => {
  const params = {
    apm: {
      events: [_common.ProcessorEvent.metric]
    },
    body: {
      track_total_hits: false,
      size: 1,
      query: {
        bool: {
          filter: [{
            term: {
              [_apm.SERVICE_NAME]: serviceName
            }
          }, ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery), {
            bool: {
              should: [{
                exists: {
                  field: _apm.METRIC_OTEL_JVM_PROCESS_CPU_PERCENT
                }
              }, {
                exists: {
                  field: _apm.METRIC_OTEL_JVM_PROCESS_MEMORY_USAGE
                }
              }, {
                exists: {
                  field: _apm.METRIC_OTEL_JVM_PROCESS_THREADS_COUNT
                }
              }, {
                exists: {
                  field: _apm.METRIC_OTEL_SYSTEM_CPU_UTILIZATION
                }
              }, {
                exists: {
                  field: _apm.METRIC_OTEL_SYSTEM_MEMORY_UTILIZATION
                }
              }]
            }
          }]
        }
      },
      _source: false
    }
  };
  const response = await apmEventClient.search('has_otel_process_metrics', params);
  return response.hits.hits.length > 0;
};
exports.hasOTelMetrics = hasOTelMetrics;