"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasEntitiesData = hasEntitiesData;
var _server = require("@kbn/observability-plugin/server");
var _elasticsearch = require("@elastic/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function hasEntitiesData(entitiesESClient, logger) {
  const params = {
    body: {
      terminate_after: 1,
      track_total_hits: true,
      size: 0
    }
  };
  try {
    const resp = await entitiesESClient.searchLatest('has_historical_entities_data', params);
    return resp.hits.total.value > 0;
  } catch (error) {
    if (error instanceof _server.WrappedElasticsearchClientError && error.originalError instanceof _elasticsearch.errors.ResponseError) {
      const type = error.originalError.body.error.type;
      logger.error(type);
      return false;
    }
    return false;
  }
}