"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorGroupSampleIds = getErrorGroupSampleIds;
var _server = require("@kbn/observability-plugin/server");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _as_mutable_array = require("../../../../common/utils/as_mutable_array");
var _apm = require("../../../../common/es_fields/apm");
var _environment_query = require("../../../../common/utils/environment_query");
var _document_type = require("../../../../common/document_type");
var _rollup = require("../../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_SAMPLES_SIZE = 10000;
async function getErrorGroupSampleIds({
  environment,
  kuery,
  serviceName,
  groupId,
  apmEventClient,
  start,
  end
}) {
  const requiredFields = (0, _as_mutable_array.asMutableArray)([_apm.ERROR_ID]);
  const resp = await apmEventClient.search('get_error_group_sample_ids', {
    apm: {
      sources: [{
        documentType: _document_type.ApmDocumentType.ErrorEvent,
        rollupInterval: _rollup.RollupInterval.None
      }]
    },
    body: {
      track_total_hits: ERROR_SAMPLES_SIZE,
      size: ERROR_SAMPLES_SIZE,
      query: {
        bool: {
          filter: [{
            term: {
              [_apm.SERVICE_NAME]: serviceName
            }
          }, {
            term: {
              [_apm.ERROR_GROUP_ID]: groupId
            }
          }, ...(0, _server.rangeQuery)(start, end), ...(0, _environment_query.environmentQuery)(environment), ...(0, _server.kqlQuery)(kuery)],
          should: [{
            term: {
              [_apm.TRANSACTION_SAMPLED]: true
            }
          }] // prefer error samples with related transactions
        }
      },
      fields: requiredFields,
      sort: (0, _as_mutable_array.asMutableArray)([{
        _score: {
          order: 'desc'
        }
      },
      // sort by _score first to ensure that errors with transaction.sampled:true ends up on top
      {
        '@timestamp': {
          order: 'desc'
        }
      } // sort by timestamp to get the most recent error
      ])
    }
  });
  const errorSampleIds = resp.hits.hits.map(item => {
    var _event$error;
    const event = (0, _utils.unflattenKnownApmEventFields)(item.fields, requiredFields);
    return (_event$error = event.error) === null || _event$error === void 0 ? void 0 : _event$error.id;
  });
  return {
    errorSampleIds,
    occurrencesCount: resp.hits.total.value
  };
}