"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getServiceEntitySummary = getServiceEntitySummary;
var _apmTypes = require("@kbn/apm-types");
var _common = require("@kbn/observability-shared-plugin/common");
var _moment = _interopRequireDefault(require("moment"));
var _with_apm_span = require("../../../utils/with_apm_span");
var _merge_entities = require("../utils/merge_entities");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getServiceEntitySummary({
  entityManagerClient,
  environment,
  serviceName
}) {
  return (0, _with_apm_span.withApmSpan)('get_service_entity_summary', async () => {
    const serviceEntitySummary = await entityManagerClient.v2.searchEntities({
      start: (0, _moment.default)().subtract(15, 'm').toISOString(),
      end: (0, _moment.default)().toISOString(),
      type: _common.BUILT_IN_ENTITY_TYPES.SERVICE_V2,
      filters: [`${_apmTypes.SERVICE_NAME}: "${serviceName}"`],
      limit: 1,
      metadata_fields: [_common.DATA_STREAM_TYPE, _apmTypes.AGENT_NAME, _apmTypes.SERVICE_ENVIRONMENT]
    });
    const serviceEntity = (0, _merge_entities.mergeEntities)({
      entities: serviceEntitySummary === null || serviceEntitySummary === void 0 ? void 0 : serviceEntitySummary.entities
    });
    return serviceEntity[0];
  });
}