"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDefaultAiAssistantStarterPromptsForAPM = useDefaultAiAssistantStarterPromptsForAPM;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useDefaultAiAssistantStarterPromptsForAPM({
  hasApmData,
  hasApmIntegrations,
  noDataConfig
}) {
  const {
    observabilityAIAssistant
  } = (0, _public.useKibana)().services;
  let screenDescription = '';
  if (!hasApmData && !hasApmIntegrations) {
    screenDescription = 'The user does not have the APM integration installed and does not have APM data.';
  } else {
    screenDescription = hasApmData ? 'The user has APM data.' : 'The user does not have APM data.';
    screenDescription = hasApmIntegrations ? `${screenDescription} The user has the APM integration installed.` : `${screenDescription} The user does not have the APM integration installed.`;
  }
  if (noDataConfig !== undefined) {
    screenDescription = `${screenDescription} The user is looking at a screen that tells them they do not have any data.`;
  }
  (0, _react.useEffect)(() => {
    return observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service.setScreenContext({
      screenDescription,
      starterPrompts: [...(hasApmData ? [] : [{
        title: _i18n.i18n.translate('xpack.apm.aiAssistant.starterPrompts.explainNoData.title', {
          defaultMessage: 'Explain'
        }),
        prompt: _i18n.i18n.translate('xpack.apm.aiAssistant.starterPrompts.explainNoData.prompt', {
          defaultMessage: "Why don't I see any data?"
        }),
        icon: 'sparkles'
      }])]
    });
  }, [hasApmData, hasApmIntegrations, noDataConfig, screenDescription, observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service]);
}