"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreakpoints = useBreakpoints;
var _eui = require("@elastic/eui");
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useBreakpoints() {
  const isXSmall = (0, _eui.useIsWithinMaxBreakpoint)('xs');
  const isSmall = (0, _eui.useIsWithinMaxBreakpoint)('s');
  const isMedium = (0, _eui.useIsWithinMaxBreakpoint)('m');
  const isLarge = (0, _eui.useIsWithinMaxBreakpoint)('l');
  const isXl = (0, _eui.useIsWithinMaxBreakpoint)('xl');
  const isXXL = (0, _eui.useIsWithinMaxBreakpoint)('xxl');
  const isXXXL = (0, _eui.useIsWithinMinBreakpoint)('xxxl');
  return (0, _react.useMemo)(() => {
    return {
      isXSmall,
      isSmall,
      isMedium,
      isLarge,
      isXl,
      isXXL,
      isXXXL
    };
  }, [isXSmall, isSmall, isMedium, isLarge, isXl, isXXL, isXXXL]);
}