"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpgradeAssistantHref = getUpgradeAssistantHref;
exports.useFleetCloudAgentPolicyHref = useFleetCloudAgentPolicyHref;
exports.useObservabilityActiveAlertsHref = useObservabilityActiveAlertsHref;
exports.useUpgradeApmPackagePolicyHref = useUpgradeApmPackagePolicyHref;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getUpgradeAssistantHref(basePath) {
  return basePath.prepend('/app/management/stack/upgrade_assistant');
}
function useFleetCloudAgentPolicyHref() {
  const {
    core: {
      http: {
        basePath
      }
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  return basePath.prepend('/app/fleet#/policies/policy-elastic-agent-on-cloud');
}
function useUpgradeApmPackagePolicyHref(packagePolicyId = '') {
  const {
    core: {
      http: {
        basePath
      }
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  return basePath.prepend(`/app/fleet/policies/policy-elastic-agent-on-cloud/upgrade-package-policy/${packagePolicyId}?from=integrations-policy-list`);
}
function useObservabilityActiveAlertsHref(kuery) {
  const {
    core: {
      http: {
        basePath
      }
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  return basePath.prepend(`/app/observability/alerts?_a=${_rison.default.encode({
    kuery,
    status: 'active'
  })}`);
}