"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverSpanLink = DiscoverSpanLink;
var _react = _interopRequireDefault(require("react"));
var _apm = require("../../../../../common/es_fields/apm");
var _discover_link = require("./discover_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDiscoverQuery(spanId) {
  const query = `${_apm.SPAN_ID}:"${spanId}"`;
  return {
    _a: {
      interval: 'auto',
      query: {
        language: 'kuery',
        query
      }
    }
  };
}
function DiscoverSpanLink({
  spanId,
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_discover_link.DiscoverLink, {
    query: getDiscoverQuery(spanId),
    children: children
  });
}